/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.modules.language.entity.ElsCompanyLanguage;
import com.els.modules.language.mapper.ElsCompanyLanguageMapper;
import com.els.modules.language.service.ElsCompanyLanguageService;
import com.els.modules.language.vo.ElsCompanyLanguageVO;
import com.els.modules.system.service.DictService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsCompanyLanguageServiceImpl
extends BaseServiceImpl<ElsCompanyLanguageMapper, ElsCompanyLanguage>
implements ElsCompanyLanguageService {
    @Autowired
    private DictService dictService;

    @Override
    public void saveElsCompanyLanguage(ElsCompanyLanguage elsCompanyLanguage) {
        ((ElsCompanyLanguageMapper)this.baseMapper).insert((Object)elsCompanyLanguage);
    }

    @Override
    public void updateElsCompanyLanguage(ElsCompanyLanguage elsCompanyLanguage) {
        ((ElsCompanyLanguageMapper)this.baseMapper).updateById((Object)elsCompanyLanguage);
    }

    @Override
    public void delElsCompanyLanguage(String id) {
        ((ElsCompanyLanguageMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsCompanyLanguage(List<String> idList) {
        ((ElsCompanyLanguageMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<ElsCompanyLanguage> getAuthLanguage(String elsAccount) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
        return list;
    }

    @Override
    public List<ElsCompanyLanguage> getAuthLanguage(List<String> elsAccount) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseEntity::getElsAccount, elsAccount)).list();
        return list;
    }

    @Override
    public void editLanguage(ElsCompanyLanguageVO elsCompanyLanguageVO) {
        List<String> elsAccounts = elsCompanyLanguageVO.getElsAccounts();
        List<String> languages = elsCompanyLanguageVO.getLanguages();
        if (!CollectionUtils.isEmpty(elsAccounts)) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseEntity::getElsAccount, elsAccounts)).list();
            List collect = list.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                ((ElsCompanyLanguageMapper)this.baseMapper).deleteBatchIds(collect);
            }
            List<DictModel> dictModels = this.dictService.queryDictItemsByCode("language", "100000");
            Map collect1 = dictModels.parallelStream().collect(Collectors.toMap(DictModel::getValue, Function.identity()));
            ArrayList<ElsCompanyLanguage> companyLanguages = new ArrayList<ElsCompanyLanguage>();
            for (String elsAccount : elsAccounts) {
                if (CollectionUtils.isEmpty(languages)) continue;
                for (String language : languages) {
                    ElsCompanyLanguage elsCompanyLanguage = new ElsCompanyLanguage();
                    elsCompanyLanguage.setElsAccount(elsAccount);
                    if (!collect1.containsKey(language)) continue;
                    elsCompanyLanguage.setLanguagesKey(language);
                    DictModel dictModel = (DictModel)collect1.get(language);
                    elsCompanyLanguage.setLanguagesValue(dictModel.getText());
                    elsCompanyLanguage.setLanguagesI18nValue(dictModel.getTextI18nKey());
                    companyLanguages.add(elsCompanyLanguage);
                }
            }
            if (!CollectionUtils.isEmpty(companyLanguages)) {
                this.saveBatch(companyLanguages);
            }
        }
    }
}

