/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.view.ELSColumnDefineEntityExcelView;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.enums.ExcelTaskTypeEnum;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.ExcelGenerateRunner;
import com.qcloud.cos.utils.IOUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.UrlResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/fileTask"})
@Api(tags={"Excel\u914d\u7f6e"})
public class BackgroundFileTaskController
extends BaseController<BackgroundFileTask, BackgroundFileTaskService> {
    private static final Logger log = LoggerFactory.getLogger(BackgroundFileTaskController.class);
    @Autowired
    private BackgroundFileTaskService backgroundFileTaskService;
    @Autowired(required=false)
    private ExcelGenerateRunner excelGenerateRunner;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"backgroundFileTask#BackgroundFileTask:list"})
    public Result<?> queryPageList(BackgroundFileTask backgroundFileTask, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)backgroundFileTask), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return Result.ok((Object)this.backgroundFileTaskService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"backgroundFileTask#BackgroundFileTask:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.backgroundFileTaskService.deleteFileTask(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6267\u884c", notes="\u901a\u8fc7id\u6267\u884c")
    @PostMapping(value={"/runTask/{id}"})
    @RequiresPermissions(value={"backgroundFileTask#BackgroundFileTask:runTask"})
    public Result<?> runTask(@PathVariable(value="id") String id) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)this.backgroundFileTaskService.getById((Serializable)((Object)id)));
        if (null == task) {
            return this.commonSuccessResult(4);
        }
        if (!TaskStatusEnum.FAIL.getCode().equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u6267\u884c\u6587\u4ef6\u4efb\u52a1"));
        }
        if (null != task.getFailTimes() && task.getFailTimes() > 2) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4efb\u52a1\u5931\u8d25\u6b21\u6570\u8d85\u8fc7\u4e09\u6b21\uff0c\u4e0d\u53ef\u518d\u6267\u884c!"));
        }
        if (ExcelTaskTypeEnum.IMPORT_ERROR.getCode().equals(task.getTaskType())) {
            this.excelGenerateRunner.immediateExec(id, null);
        } else {
            JSONObject params = (JSONObject)JSON.parseObject((String)task.getTaskParam(), JSONObject.class);
            ExportParams exportParams = (ExportParams)params.getObject("exportParams", ExportParams.class);
            exportParams.setElsAccount(TenantContext.getTenant());
            exportParams.setEntity((Map)params);
            ELSColumnDefineEntityExcelView view = new ELSColumnDefineEntityExcelView();
            view.runTask(exportParams, id, Long.valueOf(exportParams.getCount()), SysUtil.getLoginUser().getElsAccount());
        }
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u4e0b\u8f7d", notes="\u901a\u8fc7id\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/downTaskFile/{id}"})
    @RequiresPermissions(value={"backgroundFileTask#BackgroundFileTask:downTaskFile"})
    public void downTaskFile(@PathVariable(value="id") String id, HttpServletResponse response) throws MalformedURLException {
        BackgroundFileTask task = (BackgroundFileTask)((Object)this.backgroundFileTaskService.getById((Serializable)((Object)id)));
        if (null == task) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        }
        if (TaskStatusEnum.RUNNING.getCode().equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        }
        if (TaskStatusEnum.FAIL.getCode().equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u4efb\u52a1\u6587\u4ef6!"));
        }
        String path = "";
        if (ExcelTaskTypeEnum.IMPORT_ERROR.getCode().equals(task.getTaskType())) {
            log.info("downTaskFile:{}", (Object)task.getTaskFilePath());
            path = task.getTaskFilePath().contains("http") ? task.getTaskFilePath() : this.fileStoreSignServiceImpl.getDownloadPath(task.getTaskFilePath(), "local");
        } else {
            path = this.fileStoreSignServiceImpl.getDownloadPath(task.getTaskFilePath(), null);
        }
        log.info("downTaskFile path:{}", (Object)path);
        URL url = new URL(path);
        UrlResource resource = new UrlResource(url);
        try {
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setContentType("application/zip");
            InputStream inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            response.getOutputStream().write(bytes, 0, bytes.length);
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

