/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email;

import com.els.modules.email.sender.ElsMailExtendSender;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSenderCacheExtendManager {
    private static final Logger log = LoggerFactory.getLogger(EmailSenderCacheExtendManager.class);
    private static final long GUAVA_CACHE_SIZE = 10000L;
    private static final long GUAVA_CACHE_DAY = 3L;
    private static LoadingCache<String, Optional<ElsMailExtendSender>> GLOBAL_CACHE = null;

    private static LoadingCache<String, Optional<ElsMailExtendSender>> loadCache(CacheLoader<String, Optional<ElsMailExtendSender>> cacheLoader) throws Exception {
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(3L, TimeUnit.DAYS).expireAfterWrite(3L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<String, Optional<ElsMailExtendSender>>(){

            public void onRemoval(RemovalNotification<String, Optional<ElsMailExtendSender>> rn) {
                log.info("\u79fb\u9664\u90ae\u4ef6\u53d1\u9001\u5668:{}", rn.getKey());
            }
        }).recordStats().build(cacheLoader);
        return cache;
    }

    public static void put(String key, ElsMailExtendSender value) {
        try {
            GLOBAL_CACHE.put((Object)key, Optional.of(value));
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u7f13\u5b58\u503c\u51fa\u9519", (Throwable)e);
        }
    }

    public static ElsMailExtendSender get(String key) {
        try {
            Optional optional = (Optional)GLOBAL_CACHE.get((Object)key);
            if (optional.isPresent()) {
                return (ElsMailExtendSender)optional.get();
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u90ae\u7bb1\u7f13\u5b58\u62a5\u9519", (Throwable)e);
            return null;
        }
    }

    public static void remove(String key) {
        try {
            GLOBAL_CACHE.invalidate((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAll(Iterable<String> keys) {
        try {
            GLOBAL_CACHE.invalidateAll(keys);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u79fb\u9664\u7f13\u5b58\u51fa\u9519", (Throwable)e);
        }
    }

    public static void removeAll() {
        try {
            GLOBAL_CACHE.invalidateAll();
        }
        catch (Exception e) {
            log.error("\u6e05\u7a7a\u6240\u6709\u7f13\u5b58\u51fa\u9519", (Throwable)e);
        }
    }

    public static long size() {
        long size = 0L;
        try {
            size = GLOBAL_CACHE.size();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u9879\u6570\u91cf\u51fa\u9519", (Throwable)e);
        }
        return size;
    }

    static {
        try {
            GLOBAL_CACHE = EmailSenderCacheExtendManager.loadCache(new CacheLoader<String, Optional<ElsMailExtendSender>>(){

                public Optional<ElsMailExtendSender> load(String key) throws Exception {
                    return Optional.empty();
                }
            });
        }
        catch (Exception e) {
            log.error("\u90ae\u7bb1\u53d1\u9001\u5668\u7f13\u5b58\u521d\u59cb\u5316\u62a5\u9519:{}", (Throwable)e);
        }
    }
}

