/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.sender;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.enumerate.MailProtocolType;
import com.els.modules.email.EmailSenderCacheExtendManager;
import com.els.modules.email.sender.ElsMailExtendSender;
import com.els.rpc.service.EmailRpcPersistence;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElsMailExtendSender<M>
implements ElsMailExtendSender<M> {
    private static final Logger log = LoggerFactory.getLogger(AbstractElsMailExtendSender.class);

    protected void before(ElsEmailConfigDTO config) {
        if (null == config.getTo() || config.getTo().length == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getSubject())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getContent())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailUsername()) || StringUtils.isEmpty((CharSequence)config.getEmailPassword())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
    }

    protected void after(ElsEmailConfigDTO config, boolean result, String msg) {
        log.info("\u53d1\u9001\u90ae\u4ef6\u6807\u9898:{}\u7ed9:{}\uff0c\u6301\u4e45\u5316:{},\u53d1\u9001\u7ed3\u679c:{},\u4fe1\u606f:{}", new Object[]{config.getSubject(), config.getTo(), result, config.isPersistenceWhileFailed(), msg});
        if (result || BooleanUtil.isTrue((Boolean)config.isPersistenceWhileFailed())) {
            log.info("\u6301\u4e45\u5316\u90ae\u4ef6\uff0c\u53d1\u9001\u90ae\u4ef6\u6807\u9898:{}\u7ed9:{}\uff0c\u6301\u4e45\u5316:{},\u53d1\u9001\u7ed3\u679c:{},\u4fe1\u606f:{}", new Object[]{config.getSubject(), config.getTo(), result, config.isPersistenceWhileFailed(), msg});
            EmailRpcPersistence emailPersistence = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
            emailPersistence.logger(config, result, msg);
        }
    }

    @Override
    public boolean sendEmail(ElsEmailConfigDTO config, BiFunction<ElsEmailConfigDTO, M, M> messageEnhancer) {
        this.before(config);
        SendResult result = this.doSendEmail(config, messageEnhancer);
        this.after(config, result.isResult(), result.getMsg());
        return result.isResult();
    }

    protected abstract SendResult doSendEmail(ElsEmailConfigDTO var1, BiFunction<ElsEmailConfigDTO, M, M> var2);

    protected abstract void doSendEmailWithThrowException(ElsEmailConfigDTO var1, BiFunction<ElsEmailConfigDTO, M, M> var2);

    @Override
    public void sendEmailWithThrowException(ElsEmailConfigDTO config, BiFunction<ElsEmailConfigDTO, M, M> messageEnhancer) {
        this.before(config);
        boolean result = true;
        String msg = null;
        try {
            this.doSendEmailWithThrowException(config, messageEnhancer);
            this.after(config, result, msg);
        }
        catch (Exception e) {
            try {
                result = false;
                msg = e.getMessage();
                if (CharSequenceUtil.isNotEmpty((CharSequence)config.getElsAccount()) && null == messageEnhancer) {
                    String key = config.getElsAccount() + "_" + config.getEmailHost() + "_" + config.getEmailUsername() + "_" + config.getType();
                    EmailSenderCacheExtendManager.remove(key);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.after(config, result, msg);
                throw throwable;
            }
        }
    }

    protected abstract List<MailProtocolType> supportType();

    public static class SendResult {
        private boolean result;
        private String msg;

        public static SendResultBuilder builder() {
            return new SendResultBuilder();
        }

        public SendResult(boolean result, String msg) {
            this.result = result;
            this.msg = msg;
        }

        public SendResult() {
        }

        public boolean isResult() {
            return this.result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public static class SendResultBuilder {
            private boolean result;
            private String msg;

            SendResultBuilder() {
            }

            public SendResultBuilder result(boolean result) {
                this.result = result;
                return this;
            }

            public SendResultBuilder msg(String msg) {
                this.msg = msg;
                return this;
            }

            public SendResult build() {
                return new SendResult(this.result, this.msg);
            }

            public String toString() {
                return "AbstractElsMailExtendSender.SendResult.SendResultBuilder(result=" + this.result + ", msg=" + this.msg + ")";
            }
        }
    }
}

