/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.language.vo.I18nVO;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.service.CheckService;
import com.els.modules.system.service.CompanyI18nService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class I18nDataImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private I18nService i18nService;
    @Autowired
    private CheckService checkService;
    @Autowired
    private CompanyI18nService companyI18nService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<I18nVO> list = new ArrayList<I18nVO>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Map data : dataList) {
            I18nVO i18n = (I18nVO)JSON.parseObject((String)JSON.toJSONString((Object)data), I18nVO.class);
            i18n.setElsAccount(elsAccount);
            keyList.add(i18n.getI18nKey());
            list.add(i18n);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"i18n_key", keyList);
        List i18nList = this.i18nService.list((Wrapper)queryWrapper);
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Object i18n : i18nList) {
            dbMap.put(i18n.getElsAccount() + ((I18n)((Object)i18n)).getLanguage() + ((I18n)((Object)i18n)).getI18nKey(), i18n);
        }
        if (elsAccount.equals("100000")) {
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18nVO i18n : list) {
                I18n i18nZh;
                boolean isAdd = true;
                if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey(i18n.getElsAccount() + "zh" + i18n.getI18nKey())) {
                    i18nZh = new I18n();
                    i18nZh.setId(((I18n)((Object)dbMap.get(i18n.getElsAccount() + "zh" + i18n.getI18nKey()))).getId());
                    i18nZh.setI18nValue(i18n.getChinese());
                    this.i18nService.updateById((Object)i18nZh);
                    isAdd = false;
                }
                if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) && dbMap.containsKey(i18n.getElsAccount() + "en" + i18n.getI18nKey())) {
                    i18nZh = new I18n();
                    i18nZh.setId(((I18n)((Object)dbMap.get(i18n.getElsAccount() + "en" + i18n.getI18nKey()))).getId());
                    i18nZh.setI18nValue(i18n.getEnglish());
                    this.i18nService.updateById((Object)i18nZh);
                    isAdd = false;
                }
                if (!isAdd) continue;
                I18n i18nNew = new I18n();
                i18nNew.setElsAccount(elsAccount);
                i18nNew.setDeleted(CommonConstant.DEL_FLAG_0);
                i18nNew.setCreateTime(new Date());
                if (!StringUtils.isNotBlank((CharSequence)i18n.getChinese())) continue;
                i18nNew.setId(IdWorker.getIdStr());
                if (StringUtils.isBlank((CharSequence)i18n.getI18nKey())) {
                    i18nNew.setI18nKey(this.i18nService.createI18nKey(i18n.getChinese(), "import"));
                } else {
                    i18nNew.setI18nKey(i18n.getI18nKey());
                }
                String msg = this.checkExist(i18nNew.getId(), i18nNew.getLanguage() + "-" + i18nNew.getI18nKey());
                if (!"success".equals(msg)) {
                    throw new ELSBootException(msg);
                }
                i18nNew.setI18nValue(i18n.getChinese());
                i18nNew.setLanguage("zh");
                i18nInsertList.add(i18nNew);
                if (!StringUtils.isNotBlank((CharSequence)i18n.getEnglish())) continue;
                I18n eng = (I18n)((Object)SysUtil.copyProperties((Object)((Object)i18nNew), I18n.class));
                eng.setId(IdWorker.getIdStr());
                eng.setLanguage("en");
                eng.setI18nValue(i18n.getEnglish());
                i18nInsertList.add(eng);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        } else {
            ArrayList<CompanyI18n> companyI18nList = new ArrayList<CompanyI18n>();
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18nVO i18n : list) {
                I18n i18n1;
                CompanyI18n companyI18n;
                String i18nId;
                if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey("100000zh" + i18n.getI18nKey())) {
                    i18nId = ((I18n)((Object)dbMap.get("100000zh" + i18n.getI18nKey()))).getId();
                    this.companyI18nService.deleteByI18nId(elsAccount, i18nId);
                    companyI18n = new CompanyI18n();
                    companyI18n.setElsAccount(elsAccount);
                    companyI18n.setId(IdWorker.getIdStr());
                    companyI18n.setI18nId(i18nId);
                    companyI18n.setI18nKey(i18n.getI18nKey());
                    companyI18n.setLanguage("zh");
                    companyI18n.setI18nValue(i18n.getChinese());
                    companyI18n.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyI18n.setCreateTime(new Date());
                    companyI18nList.add(companyI18n);
                } else if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey(i18n.getElsAccount() + "zh" + i18n.getI18nKey())) {
                    i18n1 = new I18n();
                    i18n1.setId(((I18n)((Object)dbMap.get(i18n.getElsAccount() + "zh" + i18n.getI18nKey()))).getId());
                    i18n1.setI18nValue(i18n.getChinese());
                    this.i18nService.updateById((Object)i18n1);
                } else {
                    I18n i18nNew = new I18n();
                    i18nNew.setElsAccount(elsAccount);
                    i18nNew.setDeleted(CommonConstant.DEL_FLAG_0);
                    i18nNew.setCreateTime(new Date());
                    if (StringUtils.isNotBlank((CharSequence)i18n.getChinese())) {
                        i18nNew.setId(IdWorker.getIdStr());
                        if (StringUtils.isBlank((CharSequence)i18n.getI18nKey())) {
                            i18nNew.setI18nKey(this.i18nService.createI18nKey(i18n.getChinese(), "import"));
                        } else {
                            i18nNew.setI18nKey(i18n.getI18nKey());
                        }
                        String msg = this.checkExist(i18nNew.getId(), i18nNew.getLanguage() + "-" + i18nNew.getI18nKey());
                        if (!"success".equals(msg)) {
                            throw new ELSBootException(msg);
                        }
                        i18nNew.setLanguage("zh");
                        i18nNew.setI18nValue(i18n.getChinese());
                        i18nInsertList.add(i18nNew);
                        if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish())) {
                            I18n eng = (I18n)((Object)SysUtil.copyProperties((Object)((Object)i18nNew), I18n.class));
                            eng.setId(IdWorker.getIdStr());
                            eng.setLanguage("en");
                            eng.setI18nValue(i18n.getEnglish());
                            i18nInsertList.add(eng);
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) && dbMap.containsKey("100000en" + i18n.getI18nKey())) {
                    i18nId = ((I18n)((Object)dbMap.get("100000en" + i18n.getI18nKey()))).getId();
                    this.companyI18nService.deleteByI18nId(elsAccount, i18nId);
                    companyI18n = new CompanyI18n();
                    companyI18n.setElsAccount(elsAccount);
                    companyI18n.setId(IdWorker.getIdStr());
                    companyI18n.setI18nId(i18nId);
                    companyI18n.setI18nKey(i18n.getI18nKey());
                    companyI18n.setLanguage("en");
                    companyI18n.setI18nValue(i18n.getEnglish());
                    companyI18n.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyI18n.setCreateTime(new Date());
                    companyI18nList.add(companyI18n);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) || !dbMap.containsKey(i18n.getElsAccount() + "en" + i18n.getI18nKey())) continue;
                i18n1 = new I18n();
                i18n1.setId(((I18n)((Object)dbMap.get(i18n.getElsAccount() + "en" + i18n.getI18nKey()))).getId());
                i18n1.setI18nValue(i18n.getEnglish());
                this.i18nService.updateById((Object)i18n1);
            }
            if (!companyI18nList.isEmpty()) {
                this.companyI18nService.saveBatch(companyI18nList);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        }
        return dataList;
    }

    private String checkExist(String dataId, String value) {
        return this.checkService.checkExist(dataId, "els_i18n", "concat(language,'-',i18n_key)", value);
    }
}

