/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.permission.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.permission.entity.Permission;
import com.els.modules.permission.mapper.PermissionExtendsMapper;
import com.els.modules.permission.service.PermissionExtendsService;
import com.els.modules.permission.vo.PermissionVO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PermissionExtendsServiceImpl
extends ServiceImpl<PermissionExtendsMapper, Permission>
implements PermissionExtendsService {
    private static final Logger log = LoggerFactory.getLogger(PermissionExtendsServiceImpl.class);

    @Override
    public List<PermissionVO> queryByAccount(String elsAccount, String subAccount, Integer mobile) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        String deployWay = SysUtil.getDeployWay();
        if ("cloud".equals(deployWay)) {
            if ("1".equals(adminFlag)) {
                return ((PermissionExtendsMapper)this.baseMapper).getCompanyMenuList(elsAccount);
            }
            return ((PermissionExtendsMapper)this.baseMapper).queryByAccount(elsAccount, subAccount, mobile);
        }
        if ("1".equals(adminFlag)) {
            String purchaseAccount = SysUtil.getPurchaseAccount();
            List<PermissionVO> list = ((PermissionExtendsMapper)this.baseMapper).getLocalCompanyMenuList(elsAccount);
            if (elsAccount.equals(purchaseAccount)) {
                List<PermissionVO> subList = list.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList());
                return subList;
            }
            List<PermissionVO> authList = ((PermissionExtendsMapper)this.baseMapper).queryLocalByGroup(purchaseAccount, elsAccount);
            if (!authList.isEmpty()) {
                return authList;
            }
            return list.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
        }
        List<PermissionVO> permissionVOS = ((PermissionExtendsMapper)this.baseMapper).queryLocalByAccount(elsAccount, subAccount);
        log.info("\u4e0d\u6309\u79df\u6237\u83dc\u5355\u6388\u6743\u6765\uff0c\u96c6\u5408\u5927\u5c0f\uff1a" + permissionVOS.size());
        return permissionVOS;
    }

    @Override
    public List<PermissionDTO> selectAccountPermission(String account) {
        List<PermissionVO> list = this.queryByAccount(account.split("_")[0], account.split("_")[1], 0);
        if (list != null) {
            return SysUtil.copyProperties(list, PermissionDTO.class);
        }
        return null;
    }
}

