/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9500\u552e\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/saleAttachment"})
public class SaleAttachmentController
extends BaseController<SaleAttachment, SaleAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(SaleAttachmentController.class);
    @Autowired
    private SaleAttachmentService attachmentSaleService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"attachment#saleAttachment:list"})
    public Result<?> queryPageList(SaleAttachment attachmentSale, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)attachmentSale), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.attachmentSaleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20\u6587\u4ef6", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String factory = request.getParameter("factory");
        String materialNumber = request.getParameter("materialNumber");
        String sourceNumber = request.getParameter("sourceNumber");
        String actionRoutePath = request.getParameter("actionRoutePath");
        String saveType = request.getParameter("saveType");
        String caType = request.getParameter("caType");
        if (StrUtil.isBlank((CharSequence)businessType)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, saveType, caType);
                SaleAttachment attachment = new SaleAttachment();
                if (StringUtils.isNotBlank((CharSequence)fileInfo.getId())) {
                    attachment.setId(fileInfo.getId());
                }
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                if (CharSequenceUtil.isEmpty((CharSequence)fileType)) {
                    fileType = "5";
                }
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(TenantContext.getTenant());
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setFactory(factory);
                attachment.setMaterialNumber(materialNumber);
                attachment.setActionRoutePath(actionRoutePath);
                attachment.setSourceNumber(sourceNumber);
                SysUtil.checkFileType((String)uploadFile.getOriginalFilename());
                boolean result = this.attachmentSaleService.saveAttachment(attachment);
                if (!result) continue;
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", operateType=2)
    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", notes="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadLog"})
    public Result<?> uploadLog(@Valid @RequestBody List<SaleAttachment> attachmentList) {
        for (SaleAttachment attachment : attachmentList) {
            attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
            attachment.setUploadElsAccount(TenantContext.getTenant());
            attachment.setSendStatus("0");
            attachment.setReceiveStatus("0");
            attachment.setUploadTime(new Date());
            attachment.setSaveType(CharSequenceUtil.emptyToDefault((CharSequence)attachment.getSaveType(), (String)this.fileStoreSignServiceImpl.activeType()));
            attachment.setSourceType("1");
            if (!CharSequenceUtil.isEmpty((CharSequence)attachment.getFileType())) continue;
            attachment.setFileType("5");
        }
        this.attachmentSaleService.saveBatch(attachmentList);
        return Result.ok(attachmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"attachment#saleAttachment:downloadZip"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u4e0b\u8f7d", operateType=1)
    @PostMapping(value={"/downloadZip"})
    public void downloadZip(@RequestBody List<String> ids, HttpServletResponse response) throws IOException {
        List attachmentList = this.attachmentSaleService.listByIds(ids);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"downloadZip.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bufferedInputStream = null;
        int bufSize = 51200;
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (SaleAttachment attachment : attachmentList) {
            try {
                int length;
                InputStream inputStream = this.fileStoreSignServiceImpl.downloadFileWithInputStream(attachment.getFilePath(), attachment.getSaveType());
                bufferedInputStream = new BufferedInputStream(inputStream, bufSize);
                byte[] data = new byte[bufSize];
                Integer count = (Integer)nameIndex.get(attachment.getFileName());
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                nameIndex.put(attachment.getFileName(), count);
                String fileName = attachment.getFileName();
                if (count > 1) {
                    int index = fileName.lastIndexOf(".");
                    String name = fileName.substring(0, index);
                    String sux = fileName.substring(index);
                    fileName = name + "(" + count.toString() + ")" + sux;
                }
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOutputStream.putNextEntry(zipEntry);
                while ((length = bufferedInputStream.read(data)) != -1) {
                    zipOutputStream.write(data, 0, length);
                    response.flushBuffer();
                }
            }
            catch (Exception e) {
                log.error("{}\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)attachment.getFileName(), (Object)e.getMessage());
            }
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
    }

    private void headBuilder(HttpServletResponse response, HttpServletRequest request, String filename) throws Exception {
        filename = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(filename, "UTF-8") : new String(filename.getBytes("UTF-8"), "ISO8859-1");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
    }

    @RequiresPermissions(value={"attachment#saleAttachment:download"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        try {
            this.headBuilder(response, request, attachment.getFileName());
            this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/noToken/download"})
    public void downloadNoToken(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        try {
            this.headBuilder(response, request, attachment.getFileName());
            this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"attachment#saleAttachment:delete"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        if (null == attachment) {
            return this.commonSuccessResult(4);
        }
        String elsAccount = this.getTenantId();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_uvCXVQIWxqQG_7e96bcc2", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n_alert_IhdjQIWxqQG_29a7fa21", (String)"\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.fileStoreSignServiceImpl.delete(attachment.getFilePath(), attachment.getSaveType());
        this.attachmentSaleService.delAttachmentSale(id);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:deleteBatch"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List saleAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(saleAttachmentList = this.attachmentSaleService.listByIds(idList)))) {
            for (SaleAttachment saleAttachment : saleAttachmentList) {
                Assert.isTrue((boolean)"0".equals(saleAttachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n__QIWWWWWWIhdWxqQG_99c3bdd", (String)"\u6587\u4ef6[${0}]\u5df2\u53d1\u9001\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{saleAttachment.getFileName()}));
                filePaths.add(saleAttachment.getFilePath());
            }
        }
        this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, null);
        this.attachmentSaleService.delBatchAttachmentSale(idList);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:queryById"})
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleAttachment attachmentSale = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)attachmentSale));
    }

    @RequiresPermissions(value={"attachment#saleAttachment:send"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @ApiOperation(value="\u9644\u4ef6\u53d1\u9001", notes="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.attachmentSaleService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }
}

