/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.compare.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.storage.enumerate.AttachmentTypeEnum;
import com.els.modules.attachment.utils.SignatureFilePath;
import com.els.modules.compare.entity.ElsFileCompareHead;
import com.els.modules.compare.entity.ElsFileCompareResult;
import com.els.modules.compare.mapper.ElsFileCompareHeadMapper;
import com.els.modules.compare.service.ElsFileCompareHeadService;
import com.els.modules.compare.service.ElsFileCompareResultService;
import com.els.modules.compare.vo.ElsFileCompareHeadVO;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.system.service.ElsIpaasConfigService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsFileCompareHeadServiceImpl
extends BaseServiceImpl<ElsFileCompareHeadMapper, ElsFileCompareHead>
implements ElsFileCompareHeadService {
    @Resource
    private ElsFileCompareResultService elsFileCompareResultService;
    @Resource
    private ElsIpaasConfigService elsIpaasConfigService;
    @Autowired
    private SignatureFilePath signatureFilePath;
    @Autowired
    private SrmToIPaasService srmToIPaasService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private SaleAttachmentService saleAttachmentService;
    @Value(value="${els.config.service.address}")
    private String address;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsFileCompareHead elsFileCompareHead, List<ElsFileCompareResult> elsFileCompareResultList) {
        ((ElsFileCompareHeadMapper)this.baseMapper).insert((Object)elsFileCompareHead);
        super.setHeadDefaultValue((BaseEntity)elsFileCompareHead);
        this.insertData(elsFileCompareHead, elsFileCompareResultList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsFileCompareHead elsFileCompareHead, List<ElsFileCompareResult> elsFileCompareResultList) {
        int count = ((ElsFileCompareHeadMapper)this.baseMapper).updateById((Object)elsFileCompareHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.elsFileCompareResultService.deleteByMainId(elsFileCompareHead.getId());
        this.insertData(elsFileCompareHead, elsFileCompareResultList);
    }

    private void insertData(ElsFileCompareHead elsFileCompareHead, List<ElsFileCompareResult> elsFileCompareResultList) {
        if (!CollectionUtils.isEmpty(elsFileCompareResultList)) {
            for (ElsFileCompareResult entity : elsFileCompareResultList) {
                entity.setHeadId(elsFileCompareHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsFileCompareHead);
            }
            this.elsFileCompareResultService.saveBatch(elsFileCompareResultList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.elsFileCompareResultService.deleteByMainId(id);
        ((ElsFileCompareHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsFileCompareResultService.deleteByMainId(serializable.toString());
            ((ElsFileCompareHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<?> fileCompare(ElsFileCompareHeadVO elsFileCompareHeadVO) {
        ElsFileCompareHead elsFileCompareHead;
        if (StringUtils.isBlank((CharSequence)elsFileCompareHeadVO.getId())) {
            elsFileCompareHead = new ElsFileCompareHead();
            BeanUtils.copyProperties((Object)((Object)elsFileCompareHeadVO), (Object)((Object)elsFileCompareHead));
            TemplateHead defaultTemplateByType = this.templateHeadService.getDefaultOneTemplateByType("fileCompare");
            elsFileCompareHead.setTemplateId(defaultTemplateByType.getId());
            elsFileCompareHead.setTemplateName(defaultTemplateByType.getTemplateName());
            elsFileCompareHead.setTemplateNumber(defaultTemplateByType.getTemplateNumber());
            elsFileCompareHead.setTemplateVersion(defaultTemplateByType.getTemplateVersion() + "");
            elsFileCompareHead.setTemplateAccount(defaultTemplateByType.getElsAccount());
            ((ElsFileCompareHeadMapper)this.baseMapper).insert((Object)elsFileCompareHead);
            elsFileCompareHeadVO.setId(elsFileCompareHead.getId());
        } else {
            elsFileCompareHead = new ElsFileCompareHead();
            BeanUtils.copyProperties((Object)((Object)elsFileCompareHeadVO), (Object)((Object)elsFileCompareHead));
            this.updateMain(elsFileCompareHead, elsFileCompareHeadVO.getElsFileCompareResultList());
        }
        String fileA = this.getFilePath(elsFileCompareHeadVO.getFileASourceId(), elsFileCompareHeadVO, "A");
        String fileB = this.getFilePath(elsFileCompareHeadVO.getFileBSourceId(), elsFileCompareHeadVO, "B");
        this.log.error(":::\u5bf9\u6bd4\u6587\u4ef6\u8def\u5f84\u5206\u522b\u4e3a:" + fileA + "\u548c" + fileB);
        if (StringUtils.isNotBlank((CharSequence)fileA) && StringUtils.isNotBlank((CharSequence)fileB)) {
            JSONObject result = this.compareIpassFile(fileA, fileB);
            if (result.getBoolean("success").booleanValue()) {
                JSONObject objectNew = result.getJSONObject("data");
                JSONObject object = objectNew.getJSONObject("data");
                if (object != null) {
                    List file = JSONArray.parseArray((String)object.getString("files"), JSONObject.class);
                    ArrayList<ElsFileCompareResult> elsFileCompareResults = new ArrayList<ElsFileCompareResult>();
                    for (JSONObject jsonObject : file) {
                        ElsFileCompareResult elsFileCompareResult = new ElsFileCompareResult();
                        elsFileCompareResult.setHeadId(elsFileCompareHeadVO.getId());
                        elsFileCompareResult.setData(result.toJSONString());
                        String fileResult = jsonObject.getString("filePath");
                        if (jsonObject.containsKey((Object)"type")) {
                            elsFileCompareResult.setFbk2(jsonObject.getString("type"));
                        }
                        elsFileCompareResult.setFilePath(fileResult);
                        String[] temp = fileResult.replaceAll("////", "/").split("/");
                        if (temp.length > 1) {
                            String name = temp[temp.length - 1];
                            elsFileCompareResult.setFileName(name);
                            elsFileCompareResult.setFbk1(name.substring(name.lastIndexOf(".")));
                        }
                        elsFileCompareResults.add(elsFileCompareResult);
                    }
                    this.elsFileCompareResultService.saveBatch(elsFileCompareResults);
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsFileCompareHead::getCompareStatus, (Object)"1")).eq(BaseEntity::getId, (Object)elsFileCompareHeadVO.getId())).update((Object)new ElsFileCompareHead());
                    return Result.ok((String)"\u6bd4\u5bf9\u6210\u529f,\u8bf7\u70b9\u51fb\u67e5\u770b\u9875\u9762\u67e5\u770b\u6587\u4ef6\u7ed3\u679c");
                }
                this.updateById((Object)elsFileCompareHeadVO);
                ElsFileCompareResult elsFileCompareResult = new ElsFileCompareResult();
                elsFileCompareResult.setHeadId(elsFileCompareHeadVO.getId());
                elsFileCompareResult.setData(result.toJSONString());
                this.elsFileCompareResultService.save((Object)elsFileCompareResult);
                return Result.error((String)result.getString("message"));
            }
            ElsFileCompareResult elsFileCompareResult = new ElsFileCompareResult();
            elsFileCompareResult.setHeadId(elsFileCompareHeadVO.getId());
            elsFileCompareResult.setData(result.toJSONString());
            this.elsFileCompareResultService.save((Object)elsFileCompareResult);
            return Result.error((String)result.getString("message"));
        }
        return Result.error((String)"\u786e\u8ba4\u662f\u5426\u5747\u4ee5\u4e0a\u4f20");
    }

    private String getFilePath(String id, ElsFileCompareHeadVO elsFileCompareHeadVO, String type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PurchaseAttachment byId = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
            if (byId != null) {
                if ("A".equals(type)) {
                    elsFileCompareHeadVO.setFileABusinessType(byId.getBusinessType());
                    elsFileCompareHeadVO.setFileAType(byId.getFileType());
                    elsFileCompareHeadVO.setFileAUploadElsAccount(byId.getUploadElsAccount());
                    elsFileCompareHeadVO.setFileAUploadSubAccount(byId.getUploadSubAccount());
                    elsFileCompareHeadVO.setFileAUploadTime(byId.getUploadTime());
                    elsFileCompareHeadVO.setFileAName(byId.getFileName());
                    elsFileCompareHeadVO.setFileAPath(byId.getFilePath());
                    elsFileCompareHeadVO.setFileASize(byId.getFileSize());
                }
                if ("B".equals(type)) {
                    elsFileCompareHeadVO.setFileBBusinessType(byId.getBusinessType());
                    elsFileCompareHeadVO.setFileBType(byId.getFileType());
                    elsFileCompareHeadVO.setFileBUploadElsAccount(byId.getUploadElsAccount());
                    elsFileCompareHeadVO.setFileBUploadSubAccount(byId.getUploadSubAccount());
                    elsFileCompareHeadVO.setFileBUploadTime(byId.getUploadTime());
                    elsFileCompareHeadVO.setFileBName(byId.getFileName());
                    elsFileCompareHeadVO.setFileBPath(byId.getFilePath());
                    elsFileCompareHeadVO.setFileBSize(byId.getFileSize());
                }
                return this.getSignature(byId.getSaveType(), byId.getFilePath(), this.address + "/opt/upFiles");
            }
            SaleAttachment byId1 = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)id)));
            if (byId1 != null) {
                if ("A".equals(type)) {
                    elsFileCompareHeadVO.setFileABusinessType(byId1.getBusinessType());
                    elsFileCompareHeadVO.setFileAType(byId1.getFileType());
                    elsFileCompareHeadVO.setFileAUploadElsAccount(byId1.getUploadElsAccount());
                    elsFileCompareHeadVO.setFileAUploadSubAccount(byId1.getUploadSubAccount());
                    elsFileCompareHeadVO.setFileAUploadTime(byId1.getUploadTime());
                    elsFileCompareHeadVO.setFileAName(byId1.getFileName());
                    elsFileCompareHeadVO.setFileAPath(byId1.getFilePath());
                    elsFileCompareHeadVO.setFileASize(byId1.getFileSize());
                }
                if ("B".equals(type)) {
                    elsFileCompareHeadVO.setFileBBusinessType(byId1.getBusinessType());
                    elsFileCompareHeadVO.setFileBType(byId1.getFileType());
                    elsFileCompareHeadVO.setFileBUploadElsAccount(byId1.getUploadElsAccount());
                    elsFileCompareHeadVO.setFileBUploadSubAccount(byId1.getUploadSubAccount());
                    elsFileCompareHeadVO.setFileBUploadTime(byId1.getUploadTime());
                    elsFileCompareHeadVO.setFileBName(byId1.getFileName());
                    elsFileCompareHeadVO.setFileBPath(byId1.getFilePath());
                    elsFileCompareHeadVO.setFileBSize(byId1.getFileSize());
                }
                return this.getSignature(byId1.getSaveType(), byId1.getFilePath(), this.address + "/opt/upFiles");
            }
            return "";
        }
        return "";
    }

    private JSONObject compareIpassFile(String fileAPath, String fileBPath) {
        JSONObject data = new JSONObject();
        data.put("src_file", (Object)fileAPath);
        data.put("target_file", (Object)fileBPath);
        data.put("author", (Object)SysUtil.getLoginUser().getRealname());
        JSONObject s = this.srmToIPaasService.callIPaasInterface(data, "valueAddedApplication", this.elsIpaasConfigService.getIpaasInterfaceCode("ai_file_compare"));
        return s;
    }

    private String getSignature(String saveType, String filePath, String tempContextUrl) {
        if (AttachmentTypeEnum.LOCAL_FILE.getType().equals(saveType)) {
            return tempContextUrl + filePath;
        }
        return "";
    }
}

