/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.generate.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.els.api.dto.TableInfoQueryDto;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.generate.pojo.ColumnVo;
import com.els.modules.generate.pojo.TableVo;
import com.els.modules.generate.pojo.TemplateFileConfig;
import com.els.modules.generate.pojo.generateConfig;
import com.els.modules.generate.service.FrameworkFileUtil;
import com.els.modules.generate.service.IGenerate;
import com.els.modules.generate.service.MysqlReadTableService;
import com.els.modules.generate.util.NonceUtils;
import com.els.modules.system.util.TableFieldUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateService
extends FrameworkFileUtil
implements IGenerate<TableVo> {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerateService.class);

    @Override
    public Map<String, Object> configMap(TableVo tableVo, generateConfig generateConfig2, List<ColumnVo> columns, List<ColumnVo> originalColumns, Map<String, List<ColumnVo>> subColumnList) throws Exception {
        HashMap<String, Object> localHashMap = new HashMap<String, Object>();
        localHashMap.put("bussiPackage", generateConfig2.getBasePackage());
        localHashMap.put("entityPackage", tableVo.getEntityPackage());
        localHashMap.put("entityName", tableVo.getEntityName());
        localHashMap.put("tableName", tableVo.getTableName());
        localHashMap.put("primaryKeyField", generateConfig2.getDbTableId());
        if (tableVo.getFieldRequiredNum() == null) {
            tableVo.setFieldRequiredNum((Integer)ObjectUtil.defaultIfNull((Object)generateConfig2.getFieldRequiredNum(), (Object)-1));
        }
        if (tableVo.getSearchFieldNum() == null) {
            tableVo.setSearchFieldNum((Integer)ObjectUtil.defaultIfNull((Object)generateConfig2.getPageSearchFieldNum(), (Object)-1));
        }
        if (tableVo.getFieldRowNum() == null) {
            tableVo.setFieldRowNum(generateConfig2.getFieldRowNum());
        }
        localHashMap.put("tableVo", tableVo);
        try {
            TableInfoQueryDto dto;
            Object bean;
            if (CollUtil.isEmpty(columns)) {
                bean = (MysqlReadTableService)SpringContextUtils.getBean(MysqlReadTableService.class);
                dto = new TableInfoQueryDto();
                dto.setTableName(tableVo.getTableName());
                dto.setServiceInstanceId(tableVo.getServiceInstanceId());
                columns = ((MysqlReadTableService)bean).queryTableColumns(dto);
            }
            localHashMap.put("columns", columns);
            if (CollUtil.isEmpty(originalColumns)) {
                bean = (MysqlReadTableService)SpringContextUtils.getBean(MysqlReadTableService.class);
                dto = new TableInfoQueryDto();
                dto.setTableName(tableVo.getTableName());
                dto.setServiceInstanceId(tableVo.getServiceInstanceId());
                originalColumns = ((MysqlReadTableService)bean).queryTableColumns(dto);
            }
            localHashMap.put("originalColumns", originalColumns);
            for (ColumnVo localColumnVo : originalColumns) {
                if (!localColumnVo.getFieldName().toLowerCase().equals(generateConfig2.getDbTableId().toLowerCase())) continue;
                localHashMap.put("primaryKeyPolicy", localColumnVo.getFieldType());
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
        long l = NonceUtils.randomNextLong() + NonceUtils.currentTime();
        localHashMap.put("serialVersionUID", String.valueOf(l));
        log.info("code template data: " + localHashMap);
        return localHashMap;
    }

    @Override
    public void generateCodeFile(TableVo tableVo, generateConfig generateConfig2, List<ColumnVo> columns, List<ColumnVo> originalColumns, Map<String, List<ColumnVo>> subColumnList) throws Exception {
        if (CharSequenceUtil.isEmpty((CharSequence)tableVo.getEntityName())) {
            tableVo.setEntityName(TableFieldUtil.initialToCapital((String)tableVo.getTableName()));
        }
        String projectPath = generateConfig2.getProjectPath();
        Map<String, Object> localMap = this.configMap(tableVo, generateConfig2, columns, originalColumns, subColumnList);
        String templatePath = generateConfig2.getTemplatePath();
        if (CodeGenerateService.getPathSuffix(templatePath, "/").equals("els/code-template")) {
            templatePath = "/" + CodeGenerateService.getPathSuffix(templatePath, "/") + "/one";
        }
        TemplateFileConfig locala = new TemplateFileConfig(templatePath);
        this.generateFile(locala, projectPath, localMap, generateConfig2);
        log.info("-----------------[\u5355\u8868\u6a21\u578b\uff1a" + tableVo.getTableName() + "]-------------- \u751f\u6210\u5b8c\u6210");
    }
}

