/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.base.api.dto.BackgroundFileTaskDTO;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.enums.ExcelTaskTypeEnum;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.mapper.BackgroundFileTaskMapper;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BackgroundFileTaskServiceImpl
extends ServiceImpl<BackgroundFileTaskMapper, BackgroundFileTask>
implements BackgroundFileTaskService {
    private static final Logger log = LoggerFactory.getLogger(BackgroundFileTaskServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @Override
    public void saveImportTask(String excelBusinessOptType, String excelBusinessOptTypeName, String id, String elsAccount) {
        BackgroundFileTask task1 = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null != task1) {
            return;
        }
        BackgroundFileTask task = new BackgroundFileTask();
        task.setTaskName(CharSequenceUtil.isEmpty((CharSequence)excelBusinessOptTypeName) ? excelBusinessOptType : excelBusinessOptTypeName);
        task.setTaskType(ExcelTaskTypeEnum.IMPORT_ERROR.getCode());
        task.setTaskStatus("-1");
        task.setElsAccount(elsAccount);
        task.setTaskOptBusinessType(excelBusinessOptType);
        task.setId(id);
        this.save((Object)task);
    }

    @Override
    public void cleanTask() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BackgroundFileTask::getTaskFilePath});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(BackgroundFileTask::getTaskStatus, (Object)TaskStatusEnum.FAIL.getCode())).ge(BackgroundFileTask::getFailTimes, (Object)2);
        })).or(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.le(BaseEntity::getCreateTime, (Object)DateUtil.offsetDay((Date)new Date(), (int)-5));
        })).or(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(BackgroundFileTask::getTaskStatus, (Object)TaskStatusEnum.SUCCESS.getCode())).lt(BackgroundFileTask::getExpirationTime, (Object)new Date());
        });
        List backgroundFileTasks = ((BackgroundFileTaskMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)backgroundFileTasks)) {
            return;
        }
        ((BackgroundFileTaskMapper)this.baseMapper).deleteBatchIds(backgroundFileTasks.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        backgroundFileTasks.forEach(f -> {
            try {
                FileUtil.del((String)f.getTaskFilePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public List<BackgroundFileTask> loadExcelImportRunTask() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BackgroundFileTask::getFailTimes, BackgroundFileTask::getTaskType, BackgroundFileTask::getTaskName});
        ((LambdaQueryWrapper)wrapper.in(BackgroundFileTask::getTaskStatus, (Collection)Lists.newArrayList((Object[])new String[]{TaskStatusEnum.FAIL.getCode()}))).lt(BackgroundFileTask::getFailTimes, (Object)3);
        return ((BackgroundFileTaskMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void deleteFileTask(String id) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ((BackgroundFileTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        if (null == task || CharSequenceUtil.isBlank((CharSequence)task.getTaskFilePath())) {
            return;
        }
        try {
            if (ExcelTaskTypeEnum.IMPORT_ERROR.getCode().equals(task.getTaskType())) {
                FileUtil.del((String)task.getTaskFilePath());
            } else {
                this.fileStoreSignServiceImpl.delete(task.getTaskFilePath(), null);
            }
        }
        catch (Exception e) {
            log.info("\u5220\u9664\u6587\u4ef6\u4efb\u52a1\u5931\u8d25:id:{},name:{}", (Object)task.getId(), (Object)task.getTaskName());
        }
    }

    @Override
    public void saveExportTask(JSONObject exportParams, String excelBusinessOptType, String excelBusinessOptTypeName, String id, String elsAccount) {
        BackgroundFileTask task1 = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null != task1) {
            return;
        }
        BackgroundFileTask task = new BackgroundFileTask();
        task.setTaskName(CharSequenceUtil.isEmpty((CharSequence)excelBusinessOptTypeName) ? excelBusinessOptType : excelBusinessOptTypeName);
        task.setTaskType(ExcelTaskTypeEnum.EXPORT.getCode());
        task.setTaskStatus("-1");
        task.setElsAccount(elsAccount);
        task.setTaskOptBusinessType(excelBusinessOptType);
        task.setTaskParam(exportParams.toJSONString());
        task.setId(id);
        this.save((Object)task);
    }

    @Override
    public BackgroundFileTaskDTO getExportTask(String taskId) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)taskId)));
        if (null == task) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bfc\u51fa\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u4efb\u52a1\u8fc7\u671f\u5df2\u88ab\u6e05\u7406\uff0c\u8bf7\u91cd\u65b0\u524d\u5f80\u5177\u4f53\u9875\u9762\u91cd\u65b0\u5bfc\u51fa"));
        }
        return (BackgroundFileTaskDTO)Convert.convert(BackgroundFileTaskDTO.class, (Object)((Object)task));
    }

    @Override
    public void updateExportTaskById(BackgroundFileTaskDTO taskDTO) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)Convert.convert(BackgroundFileTask.class, (Object)taskDTO));
        ((BackgroundFileTaskMapper)this.baseMapper).updateById((Object)task);
    }
}

