/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.entity.IntegratedNodes;
import com.els.modules.integrated.entity.IntegratedParamsHead;
import com.els.modules.integrated.entity.IntegratedParamsItem;
import com.els.modules.integrated.entity.IntegratedReportData;
import com.els.modules.integrated.mapper.IntegratedReportDataMapper;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import com.els.modules.integrated.service.IntegratedNodesService;
import com.els.modules.integrated.service.IntegratedReportDataService;
import com.els.modules.integrated.vo.IntegratedNodesVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegratedReportDataServiceImpl
extends BaseServiceImpl<IntegratedReportDataMapper, IntegratedReportData>
implements IntegratedReportDataService {
    @Autowired
    private IntegratedNodesService integratedNodesService;
    @Autowired
    private IntegratedBusinessDataService integratedBusinessDataService;
    @Resource
    private IntegratedReportDataMapper integratedReportDataMapper;

    @Override
    public void add(IntegratedReportData integratedReportData) {
        ((IntegratedReportDataMapper)this.baseMapper).insert((Object)integratedReportData);
    }

    @Override
    public void edit(IntegratedReportData integratedReportData) {
        int count = ((IntegratedReportDataMapper)this.baseMapper).updateById((Object)integratedReportData);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((IntegratedReportDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((IntegratedReportDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void refreshReportData() {
        this.assemblingReportHeadData();
    }

    private void assemblingReportHeadData() {
        List<IntegratedNodesVO> integratedNodes = this.integratedNodesService.getIntegratedNodes();
        Map<String, List> collect = integratedNodes.stream().collect(Collectors.toMap(IntegratedNodes::getBusinessType, p -> {
            ArrayList<String> strings = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsHeadList())) {
                strings.addAll(this.traveseHead(p.getIntegratedParamsHeadList(), p.getBusinessType()));
            }
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsItemList())) {
                strings.addAll(this.traveseItem(p.getIntegratedParamsItemList(), p.getBusinessType()));
            }
            return strings;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        List list = ((LambdaQueryChainWrapper)this.integratedBusinessDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).list();
        Map<String, Map> stringMap = list.stream().collect(Collectors.toMap(new Function<IntegratedBusinessData, String>(){

            @Override
            public String apply(IntegratedBusinessData p) {
                return p.getIntegratedId() + "_" + p.getBusinessType();
            }
        }, p -> {
            HashMap<String, String> strings = new HashMap<String, String>();
            JSONObject jsonObject = JSONObject.parseObject((String)p.getDataJson());
            return IntegratedReportDataServiceImpl.analysisJson2(jsonObject, p.getBusinessType() + "_baseForm", strings);
        }, (value1, value2) -> {
            value1.putAll(value2);
            return value1;
        }));
        ArrayList reportDataArrayList = new ArrayList();
        if (!CollectionUtils.isEmpty(stringMap)) {
            Iterator<Map.Entry<String, Map>> it = stringMap.entrySet().iterator();
            HashMap<String, JSONObject> jsonObjectHashMap = new HashMap<String, JSONObject>();
            while (it.hasNext()) {
                Map.Entry<String, Map> pairs = it.next();
                String key2 = pairs.getKey();
                Map value3 = pairs.getValue();
                for (Map.Entry<String, List> entry : collect.entrySet()) {
                    JSONObject jsonObject;
                    String keyCollect = entry.getKey();
                    List value12 = entry.getValue();
                    if (!key2.split("_")[1].equals(keyCollect)) continue;
                    if (jsonObjectHashMap.containsKey(key2.split("_")[0])) {
                        jsonObject = (JSONObject)jsonObjectHashMap.get(key2.split("_")[0]);
                        value12.forEach(a -> {
                            if (value3.containsKey(a)) {
                                jsonObject.put(a, value3.get(a));
                            }
                        });
                        jsonObjectHashMap.put(key2.split("_")[0], jsonObject);
                        continue;
                    }
                    jsonObject = new JSONObject();
                    value12.forEach(a -> {
                        if (value3.containsKey(a)) {
                            jsonObject.put(a, value3.get(a));
                        }
                    });
                    jsonObjectHashMap.put(key2.split("_")[0], jsonObject);
                }
            }
            if (!jsonObjectHashMap.isEmpty()) {
                jsonObjectHashMap.forEach((key, value) -> reportDataArrayList.add(new IntegratedReportData().setIntegratedId((String)key).setBusinessDataType("head").setDataJson(value.toJSONString())));
            }
            List stringList = stringMap.entrySet().stream().map(key -> ((String)key.getKey()).split("_")[0]).collect(Collectors.toList());
            List list1 = ((LambdaQueryChainWrapper)this.lambdaQuery().in(IntegratedReportData::getIntegratedId, stringList)).list();
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                this.integratedReportDataMapper.deleteBatchIds(list1.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
            this.saveBatch(reportDataArrayList);
        }
    }

    private List<String> traveseHead(List<IntegratedParamsHead> integratedParamsHeadList, String businessType) {
        return integratedParamsHeadList.stream().map(p -> {
            if (StringUtils.isBlank((CharSequence)p.getFieldType()) && "dict".equals(p.getFieldType())) {
                return businessType + "_baseForm_" + p.getFieldName() + "_dictText";
            }
            if (StringUtils.isBlank((CharSequence)p.getFieldType()) && "date".equals(p.getFieldType())) {
                return businessType + "_baseForm_" + p.getFieldName();
            }
            return businessType + "_baseForm_" + p.getFieldName();
        }).collect(Collectors.toList());
    }

    private List<String> traveseItem(List<IntegratedParamsItem> integratedParamsItemList, String businessType) {
        return integratedParamsItemList.stream().map(p -> {
            if (StringUtils.isBlank((CharSequence)p.getFieldType()) && "dict".equals(p.getFieldType())) {
                return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName() + "_dictText";
            }
            if (StringUtils.isBlank((CharSequence)p.getFieldType()) && "date".equals(p.getFieldType())) {
                return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName();
            }
            return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName();
        }).collect(Collectors.toList());
    }

    public static Map<String, String> analysisJson2(Object objJson, String flag, Map<String, String> paramMap) {
        if (objJson instanceof JSONArray) {
            JSONArray objArray = (JSONArray)objJson;
            for (int i = 0; i < objArray.size(); ++i) {
                paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2(objArray.get(i), flag, paramMap));
            }
        } else if (objJson instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)objJson;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray)object;
                    String path = "";
                    path = StringUtils.isNotBlank((CharSequence)flag) ? flag.split("_")[0] + "_" + key : key;
                    paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2(objArray, path, paramMap));
                    continue;
                }
                if (object instanceof JSONObject) {
                    String path = "";
                    path = StringUtils.isNotBlank((CharSequence)flag) ? flag + "_" + key : key;
                    paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2((JSONObject)object, path, paramMap));
                    continue;
                }
                paramMap.put(flag + "_" + key, String.valueOf(object));
            }
        } else {
            return paramMap;
        }
        return paramMap;
    }
}

