/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.config;

import com.aliyun.oss.ClientConfiguration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSConfigure {
    private static final Logger log = LoggerFactory.getLogger(COSConfigure.class);
    private static COSConfigure configure = new COSConfigure();
    private String secretId;
    private String secretKey;
    private String regionId;
    private String bucketName;
    private ClientConfiguration configuration;

    public static COSConfigure getOOSconfigure() {
        if (configure == null) {
            configure = new COSConfigure();
        }
        return configure;
    }

    public COSConfigure() {
        Properties prop = this.getOSSProperties();
        this.secretId = prop.getProperty("cos.secretId").trim();
        this.secretKey = prop.getProperty("cos.secretKey").trim();
        this.regionId = prop.getProperty("cos.regionId").trim();
        this.bucketName = prop.getProperty("cos.bucketName").trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getOSSProperties() {
        Properties properties = null;
        InputStreamReader propertyIn = null;
        try {
            propertyIn = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("els-oss.properties"), StandardCharsets.UTF_8);
            properties = new Properties();
            properties.load(propertyIn);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (properties != null) {
                try {
                    propertyIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSConfigure)) {
            return false;
        }
        COSConfigure other = (COSConfigure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$secretId = this.getSecretId();
        String other$secretId = other.getSecretId();
        if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        ClientConfiguration this$configuration = this.getConfiguration();
        ClientConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSConfigure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secretId = this.getSecretId();
        result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        ClientConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public String toString() {
        return "COSConfigure(secretId=" + this.getSecretId() + ", secretKey=" + this.getSecretKey() + ", regionId=" + this.getRegionId() + ", bucketName=" + this.getBucketName() + ", configuration=" + this.getConfiguration() + ")";
    }
}

