/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.service.ColumnDefineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="columnDefineImportImpl")
public class ColumnDefineImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ColumnDefineService columnDefineService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<ColumnDefine> entityList = new ArrayList<ColumnDefine>();
        Iterator iterator = dataList.iterator();
        ArrayList codes = new ArrayList();
        for (Map data : dataList) {
            ColumnDefine entity = (ColumnDefine)this.transferEntity(data, ColumnDefine.class, excelImportDTO);
            if (null == entity) continue;
            entity.setElsAccount(TenantContext.getTenant());
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        List<String> collect = entityList.stream().map(ColumnDefine::getTableCode).distinct().collect(Collectors.toList());
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.columnDefineService.lambdaQuery().in(ColumnDefine::getTableCode, collect)).eq(ColumnDefine::getElsAccount, (Object)TenantContext.getTenant())).list();
        if (CollUtil.isEmpty((Collection)list)) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.columnDefineService.lambdaQuery().in(ColumnDefine::getTableCode, collect)).eq(ColumnDefine::getElsAccount, (Object)"100000")).list();
        }
        HashMap collect2 = CollUtil.isEmpty((Collection)list) ? new HashMap() : list.stream().collect(Collectors.toMap(item -> item.getTableCode() + "_" + item.getColumnCode(), Function.identity(), (v1, v2) -> v2));
        collect.forEach(item -> this.columnDefineService.deleteByCodeAndAccount((String)item, TenantContext.getTenant()));
        for (ColumnDefine columnDefine : entityList) {
            String key = columnDefine.getTableCode() + "_" + columnDefine.getColumnCode();
            if (!collect2.containsKey(key)) continue;
            ColumnDefine columnDefine1 = (ColumnDefine)collect2.get(key);
            columnDefine.setLink(columnDefine1.getLink());
            columnDefine.setDataFormat(columnDefine1.getDataFormat());
            columnDefine.setDictCode(columnDefine1.getDictCode());
            columnDefine.setExtendLink(columnDefine1.getExtendLink());
        }
        this.columnDefineService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

