/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ai.core.pojo.AiChatPojo;
import com.els.modules.ai.core.pojo.LlmRequestPojo;
import com.els.modules.ai.core.pojo.QuestionInfoPojo;
import com.els.modules.ai.vo.AiChatRequestDto;
import com.els.modules.base.api.service.AiChatRpcService;
import com.els.modules.system.rpc.service.BaseInvokeAiChatRpcService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u5927\u6a21\u578b\u5bf9\u8bdd"})
@RestController
@RequestMapping(value={"/ai"})
public class AiChatController {
    private static final Logger log = LoggerFactory.getLogger(AiChatController.class);
    @Resource
    private AiRequestService aiRequestService;
    @Autowired
    private BaseInvokeAiChatRpcService baseInvokeAiChatRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String AI_CHAT = "srm:ai_chat:";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @PostMapping(value={"/chat"})
    public Result<?> query(@RequestBody AiChatRequestDto aiChatRequestDto) throws Exception {
        String redisKey = aiChatRequestDto.getAppCode() + "_" + aiChatRequestDto.getBusinessType() + "_" + aiChatRequestDto.getBusinessId();
        if (!this.redisUtil.tryGetDistributedLock(AI_CHAT, redisKey, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            LlmRequestPojo llmRequest = new LlmRequestPojo();
            QuestionInfoPojo questionInfo = new QuestionInfoPojo();
            questionInfo.setQuestion(aiChatRequestDto.getQuestion());
            questionInfo.setQuestionSchema(aiChatRequestDto.getQuestionSchema());
            questionInfo.setBusinessId(aiChatRequestDto.getBusinessId());
            questionInfo.setBusinessNumber(aiChatRequestDto.getBusinessNumber());
            questionInfo.setBusinessType(aiChatRequestDto.getBusinessType());
            questionInfo.setBusinessName(aiChatRequestDto.getBusinessName());
            AiChatPojo chatChatConfig = new AiChatPojo();
            chatChatConfig.setAppCode(aiChatRequestDto.getAppCode());
            chatChatConfig.setQuestion(questionInfo);
            llmRequest.setAiChatPojo(chatChatConfig);
            AiChatRpcService aiChatRpcService = this.baseInvokeAiChatRpcService.getAiChatRpcService(aiChatRequestDto.getLoadSchemaBeanImpl());
            Map loadSchemaData = aiChatRpcService.loadSchemaData(aiChatRequestDto.getSchemaParam());
            questionInfo.setQuestionSchemaMap(loadSchemaData);
            Result result = Result.ok((Object)this.aiRequestService.runChat(llmRequest));
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(AI_CHAT, redisKey);
        }
    }
}

