/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.enumerate.PurchaseBarcodeInfoStatusEnum;
import com.els.modules.barcode.service.BarcodeSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoDetailService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoItemService;
import com.els.modules.barcode.vo.PurchaseBarcodeInfoHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/purchaseBarcodeInfoHead"})
@Api(tags={"\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868"})
public class PurchaseBarcodeInfoHeadController
extends BaseController<PurchaseBarcodeInfoHead, PurchaseBarcodeInfoHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBarcodeInfoHeadController.class);
    @Autowired
    private PurchaseBarcodeInfoHeadService purchaseBarcodeInfoHeadService;
    @Autowired
    private PurchaseBarcodeInfoItemService purchaseBarcodeInfoItemService;
    @Autowired
    private PurchaseBarcodeInfoDetailService purchaseBarcodeInfoDetailService;
    @Autowired
    private BarcodeSupplierListService barcodeSupplierListService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"barcode#info:list"})
    @PermissionDataView(businessType="barcodeInfo")
    public Result<?> queryPageList(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBarcodeInfoHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBarcodeInfoHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @PermissionDataOpt(businessType="barcodeInfo", beanClass=PurchaseBarcodeInfoHeadService.class)
    @RequiresPermissions(value={"barcode#info:add"})
    public Result<?> add(@RequestBody PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadPage) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = new PurchaseBarcodeInfoHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoHeadPage), (Object)((Object)purchaseBarcodeInfoHead));
        this.purchaseBarcodeInfoHeadService.saveMain(purchaseBarcodeInfoHead, purchaseBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList(), purchaseBarcodeInfoHeadPage.getSysBarcodeList(), purchaseBarcodeInfoHeadPage.getCustomBarcodeList(), purchaseBarcodeInfoHeadPage.getBarcodeSupplierListList());
        return Result.ok((Object)((Object)purchaseBarcodeInfoHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"barcode#info:copy"})
    public Result<?> copyData(@RequestParam(value="id") String id) {
        this.purchaseBarcodeInfoHeadService.copyData(id);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @PermissionDataOpt(businessType="barcodeInfo", beanClass=PurchaseBarcodeInfoHeadService.class)
    @RequiresPermissions(value={"barcode#info:edit"})
    public Result<?> edit(@RequestBody PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadPage) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = new PurchaseBarcodeInfoHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoHeadPage), (Object)((Object)purchaseBarcodeInfoHead));
        this.purchaseBarcodeInfoHeadService.updateMain(purchaseBarcodeInfoHead, purchaseBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList(), purchaseBarcodeInfoHeadPage.getSysBarcodeList(), purchaseBarcodeInfoHeadPage.getCustomBarcodeList(), purchaseBarcodeInfoHeadPage.getBarcodeSupplierListList());
        return this.queryById(purchaseBarcodeInfoHeadPage.getId());
    }

    @RequiresPermissions(value={"barcode#info:publish"})
    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @PermissionDataOpt(businessType="barcodeInfo", beanClass=PurchaseBarcodeInfoHeadService.class)
    public Result<?> publish(@RequestBody PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadPage) {
        if (purchaseBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList().size() <= 0) {
            Assert.isNotEmpty(purchaseBarcodeInfoHeadPage.getBarcodeSupplierListList(), (String)I18nUtil.translate((String)"i18n_alert_ToWcCcxOLV_882ff66d", (String)"\u6761\u7801\u5c5e\u6027\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if ("1".equals(purchaseBarcodeInfoHeadPage.getPublishAudit())) {
            Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_TPUztFxOhx_fc842d94", (String)"\u9700\u8981\u5ba1\u6279\u5355\u636e\u4e0d\u80fd\u53d1\u5e03"));
        }
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = new PurchaseBarcodeInfoHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoHeadPage), (Object)((Object)purchaseBarcodeInfoHead));
        this.purchaseBarcodeInfoHeadService.publish(purchaseBarcodeInfoHead, purchaseBarcodeInfoHeadPage.getPurchaseBarcodeInfoItemList(), purchaseBarcodeInfoHeadPage.getSysBarcodeList(), purchaseBarcodeInfoHeadPage.getCustomBarcodeList(), purchaseBarcodeInfoHeadPage.getBarcodeSupplierListList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @PermissionDataOpt(businessType="barcodeInfo", beanClass=PurchaseBarcodeInfoHeadService.class)
    @RequiresPermissions(value={"barcode#info:invalid"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        LambdaUpdateWrapper lambdaUpdateWrapperPurchase = new LambdaUpdateWrapper();
        lambdaUpdateWrapperPurchase.eq(BaseEntity::getId, (Object)id);
        lambdaUpdateWrapperPurchase.set(PurchaseBarcodeInfoHead::getInfoStatus, (Object)PurchaseBarcodeInfoStatusEnum.INVALID.getValue());
        this.purchaseBarcodeInfoHeadService.update((Wrapper)lambdaUpdateWrapperPurchase);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#info:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBarcodeInfoHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#info:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO = new PurchaseBarcodeInfoHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeInfoHead), (Object)((Object)purchaseBarcodeInfoHeadVO));
        List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList = this.purchaseBarcodeInfoItemService.selectByMainId(id);
        purchaseBarcodeInfoHeadVO.setPurchaseBarcodeInfoItemList(purchaseBarcodeInfoItemList);
        List<PurchaseBarcodeInfoDetail> purchaseBarcodeInfoDetailList = this.purchaseBarcodeInfoDetailService.selectByMainId(id);
        List<PurchaseBarcodeInfoDetail> sysBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
        purchaseBarcodeInfoHeadVO.setSysBarcodeList(sysBarcodeList);
        List<PurchaseBarcodeInfoDetail> customBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
        purchaseBarcodeInfoHeadVO.setCustomBarcodeList(customBarcodeList);
        List<BarcodeSupplierList> barcodeSupplierListList = this.barcodeSupplierListService.selectByMainId(id);
        purchaseBarcodeInfoHeadVO.setBarcodeSupplierListList(barcodeSupplierListList);
        return Result.ok((Object)((Object)purchaseBarcodeInfoHeadVO));
    }

    @RequiresPermissions(value={"barcode#info:detail"})
    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5355\u884c\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5355\u884c\u8868")
    @GetMapping(value={"/queryPurchaseBarcodeInfoItemByMainId"})
    public Result<?> queryPurchaseBarcodeInfoItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList = this.purchaseBarcodeInfoItemService.selectByMainId(id);
        return Result.ok(purchaseBarcodeInfoItemList);
    }

    @RequiresPermissions(value={"barcode#info:detail"})
    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u660e\u7ec6\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u660e\u7ec6\u8868")
    @GetMapping(value={"/queryPurchaseBarcodeInfoDetailByMainId"})
    public Result<?> queryPurchaseBarcodeInfoDetailListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodeInfoDetail> purchaseBarcodeInfoDetailList = this.purchaseBarcodeInfoDetailService.selectByMainId(id);
        return Result.ok(purchaseBarcodeInfoDetailList);
    }

    @RequiresPermissions(value={"barcode#info:detail"})
    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u6761\u7801\u4f9b\u5e94\u5546\u5217\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5355\u5934\u8868id\u67e5\u8be2\u6761\u7801\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/queryBarcodeSupplierListByMainId"})
    public Result<?> queryBarcodeSupplierListListByMainId(@RequestParam(name="id") String id) {
        List<BarcodeSupplierList> barcodeSupplierListList = this.barcodeSupplierListService.selectByMainId(id);
        return Result.ok(barcodeSupplierListList);
    }

    @RequiresPermissions(value={"barcode#info:generateBarcode"})
    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5355\u884c\u8868", value="\u751f\u6210\u6761\u7801\u5355")
    @ApiOperation(value="\u751f\u6210\u6761\u7801\u5355", notes="\u751f\u6210\u6761\u7801\u5355")
    @PostMapping(value={"/generateBarcode"})
    public Result<?> generateBarcode(@RequestBody PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO) throws Exception {
        if (purchaseBarcodeInfoHeadVO.getPurchaseBarcodeInfoItemList().size() > 0 && StringUtils.isEmpty((CharSequence)purchaseBarcodeInfoHeadVO.getPurchaseBarcodeInfoItemList().get(0).getAttribute())) {
            Assert.isNotBlank((String)purchaseBarcodeInfoHeadVO.getPurchaseBarcodeInfoItemList().get(0).getAttribute(), (String)I18nUtil.translate((String)"\u5c5e\u6027\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"\u5c5e\u6027\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List<PurchaseBarcodeInfoDetail> barcodeList = this.purchaseBarcodeInfoItemService.generateBarcode(purchaseBarcodeInfoHeadVO);
        return Result.ok(barcodeList);
    }
}

