/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.pojo.AiChatAppPojo;
import com.els.modules.ai.core.pojo.AiChatExamplarPojo;
import com.els.modules.ai.core.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.core.pojo.AiChatPojo;
import com.els.modules.ai.core.pojo.LlmRequestPojo;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.core.pojo.QuestionInfoPojo;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.service.AiChatAppService;
import com.els.modules.ai.service.AiChatExamplarService;
import com.els.modules.ai.service.AiChatModelConfigService;
import java.util.Date;
import java.util.List;

public class AgentAiRequestService {
    public static LlmResponsePojo runChat(LlmRequestPojo llmRequest) {
        AiChatPojo chatDto = llmRequest.getAiChatPojo();
        if (null == chatDto) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppPojo chatAppConfig = ((AiChatAppService)SpringContextUtils.getBean(AiChatAppService.class)).loadAiChatAppByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        chatDto.setLanguage("zh");
        chatDto.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfoPojo questionInfo = chatDto.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarPojo> chatExamplers = ((AiChatExamplarService)SpringContextUtils.getBean(AiChatExamplarService.class)).loadExamplersByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        llmRequest.setAiChatPojo(chatDto);
        llmRequest.setAiChatAppPojo(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiChatModelConfigPojo aiChatModelConfigDto = ((AiChatModelConfigService)SpringContextUtils.getBean(AiChatModelConfigService.class)).loadModelConfigByProvider(chatAppConfig.getModelProvider(), chatAppConfig.getModelName(), SysUtil.getLoginUser().getElsAccount());
        chatAppConfig.setAiChatModelConfigPojo(aiChatModelConfigDto);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponsePojo result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        result.setLlmRequestPojo(llmRequest);
        return result;
    }
}

