/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core;

import com.els.modules.ai.agent.core.clean.CleanStrategy;
import com.els.modules.ai.agent.core.collect.CollectResultStrategy;
import com.els.modules.ai.agent.core.collect.CollectStrategy;
import com.els.modules.ai.agent.core.vote.VoteStrategy;
import com.google.common.collect.Maps;
import java.util.Map;

public class AgentStrategyFactory {
    private static Map<String, CleanStrategy> FACTORY = Maps.newConcurrentMap();
    private static Map<String, VoteStrategy> VOTE_FACTORY = Maps.newConcurrentMap();
    private static Map<String, CollectStrategy> COLLECT_FACTORY = Maps.newConcurrentMap();
    private static Map<String, CollectResultStrategy> COLLECT_RESULT_FACTORY = Maps.newConcurrentMap();

    public static void register(String type, CleanStrategy cleanStrategy) {
        FACTORY.put(type, cleanStrategy);
    }

    public static CleanStrategy getCleanStrategy(String type) {
        return FACTORY.get(type);
    }

    public static void register(String type, VoteStrategy voteStrategy) {
        VOTE_FACTORY.put(type, voteStrategy);
    }

    public static VoteStrategy getVoteStrategy(String type) {
        return VOTE_FACTORY.get(type);
    }

    public static void register(String type, CollectStrategy collectStrategy) {
        COLLECT_FACTORY.put(type, collectStrategy);
    }

    public static CollectStrategy getCollectStrategy(String type) {
        return COLLECT_FACTORY.get(type);
    }

    public static void register(String type, CollectResultStrategy collectResultStrategy) {
        COLLECT_RESULT_FACTORY.put(type, collectResultStrategy);
    }

    public static CollectResultStrategy getCollectResultStrategy(String type) {
        return COLLECT_RESULT_FACTORY.get(type);
    }
}

