/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.agent.core.AgentStrategyFactory;
import com.els.modules.ai.agent.core.collect.CollectStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentDataCollectConfigItem;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCollectRunner {
    private static final Logger log = LoggerFactory.getLogger(DataCollectRunner.class);

    public static JSONObject collect(AgentLlmRequestPojo llmRequest, List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList) {
        JSONObject collectDataMap = new JSONObject();
        List configItems = aiAgentDataCollectConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(configItems)) {
            collectDataMap.put("questionSchema", (Object)llmRequest.getAiChatPojo().getQuestion().getQuestionSchema());
            return collectDataMap;
        }
        JSONObject questionQuerySchema = llmRequest.getAiChatPojo().getQuestion().getQuestionQuerySchema();
        if (null == questionQuerySchema) {
            questionQuerySchema = new JSONObject();
        }
        questionQuerySchema.put("X-Access-Token", (Object)SpringContextUtils.getHttpServletRequest().getHeader("x-access-token"));
        JSONObject finalQuestionQuerySchema = questionQuerySchema;
        CompletableFuture[] futures = (CompletableFuture[])configItems.stream().map(item -> CompletableFuture.runAsync(() -> {
            try {
                CollectStrategy collectStrategy = AgentStrategyFactory.getCollectStrategy(item.getRequestType());
                String result = collectStrategy.execute(llmRequest, (AiAgentDataCollectConfigItem)((Object)item), finalQuestionQuerySchema);
                JSONObject jSONObject = collectDataMap;
                synchronized (jSONObject) {
                    collectDataMap.put(item.getName(), (Object)result);
                }
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u6536\u96c6\u5904\u7406\u5f02\u5e38 [{}]", (Object)item.getName(), (Object)e);
            }
        })).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u6570\u636e\u6536\u96c6\u5e76\u884c\u5904\u7406\u5f02\u5e38", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        collectDataMap.put("questionSchema", (Object)llmRequest.getAiChatPojo().getQuestion().getQuestionSchema());
        return collectDataMap;
    }
}

