/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.clean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.agent.core.clean.AbstractCleanStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentDataCleanConfigItem;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JavaScriptEngineCleanStrategy
extends AbstractCleanStrategy {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngineCleanStrategy.class);

    @Override
    public String type() {
        return "JAVA_SCRIPT";
    }

    private JSONObject convertGraalValueToJSON(Value value) {
        if (value.isHostObject()) {
            return (JSONObject)value.asHostObject();
        }
        try {
            return JSON.parseObject((String)value.toString());
        }
        catch (Exception e) {
            log.warn("\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38: {}", (Object)e.getMessage());
            return new JSONObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject execute(AgentLlmRequestPojo llmRequest, AiAgentDataCleanConfigItem config, JSONObject input) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.newBuilder().allowArrayAccess(true).allowListAccess(true).allowMapAccess(true).build()).allowIO(false).allowCreateThread(false).allowNativeAccess(false).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("input", (Object)input);
            Source scriptSource = Source.newBuilder((String)"js", (CharSequence)config.getItemConfig(), (String)"cleanScript.js").build();
            Value result = context.eval(scriptSource);
            if (result.isHostObject()) {
                JSONObject jSONObject2 = (JSONObject)result.asHostObject();
                return jSONObject2;
            }
            JSONObject jSONObject = JSON.parseObject((String)result.toString());
            return jSONObject;
        }
        catch (Exception e) {
            log.error("\u811a\u672c\u6267\u884c\u5f02\u5e38 | \u914d\u7f6eID:{} | \u9519\u8bef: {}", (Object)config.getId(), (Object)e.getMessage());
            return input;
        }
    }
}

