/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.collect.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.agent.core.collect.result.AbstractCollectResultStrategy;
import com.els.modules.ai.agent.entity.AiAgentDataCollectConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class SpelEngineCollectResultStrategy
extends AbstractCollectResultStrategy {
    private static final Logger log = LoggerFactory.getLogger(SpelEngineCollectResultStrategy.class);

    @Override
    public String type() {
        return "SPEL";
    }

    @Override
    public String execute(AiAgentDataCollectConfigItem config, String body) {
        String spel = config.getItemConfig();
        if ("obj".equals(config.getDataType())) {
            JSONObject jsonObject = JSON.parseObject((String)body);
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)jsonObject);
            Expression exp = parser.parseExpression(spel);
            return JSON.toJSONString((Object)exp.getValue((EvaluationContext)context));
        }
        if ("array".equals(config.getDataType())) {
            JSONArray jsonArray = JSON.parseArray((String)body);
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)jsonArray);
            Expression exp = parser.parseExpression(spel);
            return JSON.toJSONString((Object)exp.getValue((EvaluationContext)context));
        }
        return body;
    }
}

