/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.vote;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.agent.core.AgentEnhanceService;
import com.els.modules.ai.agent.core.vote.AbstractVoteStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineVoteStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public Map<String, LlmResponsePojo> execute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        String cleanConfig = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AgentEnhanceService bean = (AgentEnhanceService)SpringContextUtils.getBean((String)cleanConfig, AgentEnhanceService.class);
                return bean.runVoted(llmRequest, responsePojoMap);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return responsePojoMap;
    }
}

