/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy.dync;

import com.els.modules.ai.core.modelStrategy.dync.DynamicAiResponseObjConfig;
import com.els.modules.ai.core.modelStrategy.dync.DynamicClassGenerator;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.service.AiServices;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;

public class DynamicAIServiceFactory {
    private final DynamicClassGenerator generator = new DynamicClassGenerator();

    public <T> T createService(DynamicAiResponseObjConfig config, ChatLanguageModel model) {
        try {
            Class<?> responseClass = this.generator.generateResponseClass(config);
            Class<?> extractorInterface = this.createExtractorInterface(responseClass);
            return (T)AiServices.create(extractorInterface, (ChatLanguageModel)model);
        }
        catch (Exception e) {
            throw new RuntimeException("Service creation failed", e);
        }
    }

    private Class<?> createExtractorInterface(Class<?> returnType) throws CannotCompileException, NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctInterface = pool.makeInterface("DynamicExtractor_" + returnType.getSimpleName());
        CtClass returnCtClass = pool.get(returnType.getName());
        CtMethod method = CtNewMethod.abstractMethod((CtClass)returnCtClass, (String)"generateResult", (CtClass[])new CtClass[]{pool.get(String.class.getName())}, null, (CtClass)ctInterface);
        ctInterface.addMethod(method);
        return ctInterface.toClass();
    }
}

