/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.vote.VoteStrategy;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResultRunner {
    private static final Logger log = LoggerFactory.getLogger(DataResultRunner.class);

    public static LlmResponsePojo vote(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        List<AiAgentResultConfigItem> configItems = aiAgentResultConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).sorted(Comparator.comparing(AiAgentResultConfigItem::getOrderSort)).toList();
        if (configItems.isEmpty()) {
            return responsePojoMap.values().iterator().next();
        }
        if (configItems.size() == 1 && responsePojoMap.size() == 1 && CharSequenceUtil.isEmpty((CharSequence)configItems.get(0).getItemConfig())) {
            return responsePojoMap.values().iterator().next();
        }
        Map<String, LlmResponsePojo> inputMap = new HashMap<String, LlmResponsePojo>(responsePojoMap);
        for (AiAgentResultConfigItem item : aiAgentResultConfigItemList) {
            if (!CharSequenceUtil.isNotEmpty((CharSequence)item.getItemType())) continue;
            VoteStrategy voteStrategy = AgentStrategyFactory.getVoteStrategy(item.getItemType());
            inputMap = voteStrategy.execute(llmRequest, inputMap, item);
        }
        if (null == inputMap || inputMap.isEmpty()) {
            return responsePojoMap.values().iterator().next();
        }
        return (LlmResponsePojo)inputMap.values().iterator().next();
    }
}

