/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.ainpl.entity.AiOrderCreationModelExtendItem;
import com.els.modules.ainpl.entity.AiOrderCreationModelHead;
import com.els.modules.ainpl.entity.AiOrderCreationModelItem;
import com.els.modules.ainpl.mapper.AiOrderCreationModelHeadMapper;
import com.els.modules.ainpl.service.AiOrderCreationModelExtendItemService;
import com.els.modules.ainpl.service.AiOrderCreationModelHeadService;
import com.els.modules.ainpl.service.AiOrderCreationModelItemService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AiOrderCreationModelHeadServiceImpl
extends ServiceImpl<AiOrderCreationModelHeadMapper, AiOrderCreationModelHead>
implements AiOrderCreationModelHeadService {
    @Resource
    private AiOrderCreationModelItemService aiOrderCreationModelItemService;
    @Resource
    private AiOrderCreationModelExtendItemService aiOrderCreationModelExtendItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        ((AiOrderCreationModelHeadMapper)this.baseMapper).insert((Object)aiOrderCreationModelHead);
        this.insertData(aiOrderCreationModelHead, aiOrderCreationModelItemList, aiOrderCreationModelExtendItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        int count = ((AiOrderCreationModelHeadMapper)this.baseMapper).updateById((Object)aiOrderCreationModelHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.aiOrderCreationModelItemService.deleteByMainId(aiOrderCreationModelHead.getId());
        this.aiOrderCreationModelExtendItemService.deleteByMainId(aiOrderCreationModelHead.getId());
        this.insertData(aiOrderCreationModelHead, aiOrderCreationModelItemList, aiOrderCreationModelExtendItemList);
    }

    private void insertData(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        if (!CollectionUtils.isEmpty(aiOrderCreationModelItemList)) {
            for (AiOrderCreationModelItem aiOrderCreationModelItem : aiOrderCreationModelItemList) {
                aiOrderCreationModelItem.setHeadId(aiOrderCreationModelHead.getId());
                SysUtil.setSysParam((BaseEntity)aiOrderCreationModelItem, (BaseEntity)aiOrderCreationModelHead);
            }
            this.aiOrderCreationModelItemService.saveBatch(aiOrderCreationModelItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(aiOrderCreationModelExtendItemList)) {
            for (AiOrderCreationModelExtendItem aiOrderCreationModelExtendItem : aiOrderCreationModelExtendItemList) {
                aiOrderCreationModelExtendItem.setHeadId(aiOrderCreationModelHead.getId());
                SysUtil.setSysParam((BaseEntity)aiOrderCreationModelExtendItem, (BaseEntity)aiOrderCreationModelHead);
            }
            this.aiOrderCreationModelExtendItemService.saveBatch(aiOrderCreationModelExtendItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.aiOrderCreationModelItemService.deleteByMainId(id);
        this.aiOrderCreationModelExtendItemService.deleteByMainId(id);
        ((AiOrderCreationModelHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.aiOrderCreationModelItemService.deleteByMainId(serializable.toString());
            this.aiOrderCreationModelExtendItemService.deleteByMainId(serializable.toString());
            ((AiOrderCreationModelHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

