/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core.nlp;

import com.els.modules.ainpl.core.nlp.NlpProcessor;
import com.els.modules.ainpl.core.nlp.SimilarityCalculator;
import com.els.modules.ainpl.vo.AiOrderCreationFiledSchemaDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QuestionAnalysisService {
    @Autowired
    private NlpProcessor nlpProcessor;
    @Value(value="${els.aiOrderCreation.similarity.threshold:0.2}")
    private double similarityThreshold = 0.2;

    public boolean isQuestionRelevant(List<AiOrderCreationFiledSchemaDTO> schemaList, String question) {
        if (question == null || question.trim().isEmpty()) {
            return false;
        }
        List<String> questionKeywords = this.nlpProcessor.extractKeywords(question);
        if (questionKeywords.isEmpty()) {
            return false;
        }
        return schemaList.stream().anyMatch(spec -> this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaDTO)spec) >= this.similarityThreshold);
    }

    private List<AiOrderCreationFiledSchemaDTO> getRelevantSpecs(List<AiOrderCreationFiledSchemaDTO> schemaList, String question) {
        if (!this.isQuestionRelevant(schemaList, question)) {
            return Collections.emptyList();
        }
        List<String> questionKeywords = this.nlpProcessor.extractKeywords(question);
        return schemaList.stream().filter(spec -> this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaDTO)spec) >= this.similarityThreshold).sorted((s1, s2) -> Double.compare(this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaDTO)s2), this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaDTO)s1))).collect(Collectors.toList());
    }

    private double calculateSpecSimilarity(List<String> questionKeywords, AiOrderCreationFiledSchemaDTO spec) {
        ArrayList<String> specTokens = new ArrayList<String>();
        specTokens.add(spec.getFieldName());
        specTokens.addAll(spec.getFieldAlias());
        return SimilarityCalculator.cosineSimilarity(questionKeywords, specTokens);
    }
}

