/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.entity.ExternalVoucherParam;
import com.els.modules.account.enums.ExternalVoucherTypeEnum;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.account.service.ExternalVoucherParamService;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.account.vo.ExternalVoucherBindLoginVo;
import com.els.modules.account.vo.VoucherSsoVO;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.extend.ConfigExtendInter;
import com.els.modules.justauth.util.QRCodeUtil;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.justauth.util.WechatEnterpriseApiUtil;
import com.els.modules.justauth.vo.ConfigExtendVO;
import com.els.modules.justauth.vo.TicketVO;
import com.els.modules.justauth.vo.WechatEnterpriseDevelopVO;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406")
@RestController
@RequestMapping(value={"/base/externalVoucher"})
public class ExternalVoucherController
extends BaseController<ExternalVoucher, ExternalVoucherService> {
    @Resource
    private ExternalAccountService externalAccountService;
    @Resource
    private ExternalVoucherParamService externalVoucherParamService;
    @Resource
    @Lazy
    private ConfigExtendInter configExtendInter;
    @Autowired
    @Lazy
    private WechatEnterpriseApiUtil wechatEnterpriseApiUtil;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"externalVoucher:list"})
    public Result<?> queryPageList(ExternalVoucher voucher, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)voucher), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)this.getElsAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((ExternalVoucherService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"externalVoucher:add"})
    public Result<?> add(@RequestBody ExternalVoucher voucher) {
        ((ExternalVoucherService)this.service).add(voucher);
        return Result.ok((Object)((Object)voucher));
    }

    @AutoLog(busModule="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"externalVoucher:edit"})
    public Result<?> edit(@RequestBody ExternalVoucher voucher) {
        List<ConfigExtendVO> list = this.configExtendInter.buildExtendParam(voucher.getVoucherType(), "");
        list = list.stream().filter(x -> BooleanUtil.isTrue((Boolean)x.getConfigRequired())).collect(Collectors.toList());
        JSONObject jsonObject = JSONObject.parseObject((String)CharSequenceUtil.emptyToDefault((CharSequence)voucher.getExtendParam(), (String)"{}"));
        for (ConfigExtendVO p : list) {
            if (jsonObject.containsKey(p.getParamName()) && !CharSequenceUtil.isEmpty((CharSequence)jsonObject.getString(p.getParamName()))) continue;
            throw new ELSBootException(I18nUtil.translate((String)"\u62d3\u5c55\u53c2\u6570\u4e2d{0}\u4e0d\u80fd\u4e3a\u7a7a", (String)p.getParamName()));
        }
        ((ExternalVoucherService)this.service).edit(voucher);
        return this.queryById(voucher.getId());
    }

    @AutoLog(busModule="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"externalVoucher:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((ExternalVoucherService)this.service).delete(id);
        return Result.ok();
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"externalVoucher:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ExternalVoucher dbVoucher = (ExternalVoucher)((Object)((ExternalVoucherService)this.service).getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)id)).eq(ParentEntity::getElsAccount, (Object)this.getElsAccount())));
        if (null != dbVoucher && CharSequenceUtil.isEmpty((CharSequence)dbVoucher.getExtendParam())) {
            dbVoucher.setExtendParam(this.configExtendInter.buildExtendParamString(dbVoucher.getVoucherType(), ""));
        }
        return Result.ok((Object)((Object)dbVoucher));
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u767b\u5f55\u7684\u914d\u7f6e", description="\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u767b\u5f55\u7684\u914d\u7f6e")
    @GetMapping(value={"/getBindLoginList"})
    public Result<?> getBindList() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(ExternalVoucher::getVoucherKey)).isNotNull(ExternalVoucher::getVoucherSecret)).eq(ExternalVoucher::getBindLogin, (Object)"1");
        List list = ((ExternalVoucherService)this.service).list((Wrapper)wrapper);
        List<String> type = this.externalAccountService.loadAccountBindType(TenantContext.getTenant(), SrmUtil.getLoginUser().getId());
        ArrayList<ExternalVoucherBindLoginVo> resultList = new ArrayList<ExternalVoucherBindLoginVo>();
        for (ExternalVoucher voucher : list) {
            ExternalVoucherBindLoginVo bindLoginVo = new ExternalVoucherBindLoginVo();
            bindLoginVo.setAuthType(voucher.getVoucherType());
            bindLoginVo.setBindStatus(type.contains(voucher.getVoucherType()) ? "1" : "0");
            bindLoginVo.setEnterpriseName(SrmUtil.getLoginUser().getCompanyName());
            bindLoginVo.setElsAccount(voucher.getElsAccount());
            resultList.add(bindLoginVo);
        }
        return Result.ok(resultList);
    }

    @Operation(summary="\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u4ee3\u5f00\u53d1\u6388\u6743\u4e8c\u7ef4\u7801", description="\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u4ee3\u5f00\u53d1\u6388\u6743\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/getCustomizedAuthQCode"})
    @RequiresPermissions(value={"externalVoucher:getCustomizedAuthQCode"})
    public Result<?> getCustomizedAuthUrlCode() throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount())).isNotNull(ExternalVoucher::getVoucherKey)).isNotNull(ExternalVoucher::getVoucherSecret)).eq(ExternalVoucher::getVoucherType, (Object)ExternalVoucherTypeEnum.WECHAT_ENTERPRISE_DEVELOP.getValue())).eq(ExternalVoucher::getBindLogin, (Object)"1");
        List list = ((ExternalVoucherService)this.service).list((Wrapper)wrapper);
        if (list.isEmpty()) {
            throw new ELSBootException("\u7cfb\u7edf\u672a\u914d\u4f01\u4e1a\u5fae\u4fe1\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ExternalVoucher template = null;
        for (ExternalVoucher voucher : list) {
            JSONObject jsonObject;
            String configType;
            String extendParam = voucher.getExtendParam();
            if (!CharSequenceUtil.isNotEmpty((CharSequence)extendParam) || !"templateConfig".equalsIgnoreCase(configType = (jsonObject = JSON.parseObject((String)extendParam)).getString("configType"))) continue;
            List<ConfigExtendVO> param = this.configExtendInter.buildExtendParam(ExternalVoucherTypeEnum.WECHAT_ENTERPRISE_DEVELOP.getValue(), "");
            param = param.stream().filter(x -> BooleanUtil.isTrue((Boolean)x.getConfigRequired())).collect(Collectors.toList());
            for (ConfigExtendVO p : param) {
                if (jsonObject.containsKey(p.getParamName()) && !CharSequenceUtil.isEmpty((CharSequence)jsonObject.getString(p.getParamName()))) continue;
                throw new ELSBootException(I18nUtil.translate((String)"\u4f01\u4e1a\u5fae\u4fe1\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u914d\u7f6e\u7684\u62d3\u5c55\u53c2\u6570\u4e2d{0}\u4e0d\u80fd\u4e3a\u7a7a", (String)p.getParamName()));
            }
            template = voucher;
            break;
        }
        if (null == template) {
            throw new ELSBootException("\u7cfb\u7edf\u672a\u914d\u4f01\u4e1a\u5fae\u4fe1\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String extentParam = CharSequenceUtil.emptyToDefault((CharSequence)template.getExtendParam(), (String)"{}");
        WechatEnterpriseDevelopVO developVO = (WechatEnterpriseDevelopVO)JSON.parseObject((String)extentParam, WechatEnterpriseDevelopVO.class);
        String qrCode = QRCodeUtil.createQRCode(this.wechatEnterpriseApiUtil.getCustomizedAuthUrl(template.getVoucherKey(), template.getVoucherSecret(), TenantContext.getTenant(), Lists.newArrayList((Object[])developVO.getSuiteId().split(","))));
        return Result.ok((String)qrCode);
    }

    @Operation(summary="\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801", description="\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/queryWechatMpQrCode/{busAccount}"})
    public Result<Object> queryWechatMpQrCode(@PathVariable(value="busAccount") String busAccount) {
        StringBuilder sb = new StringBuilder();
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        sb.append(loginUser.getElsAccount()).append("-").append(loginUser.getId());
        ExternalVoucherDto config = ((ExternalVoucherService)this.service).getVoucherByType(busAccount, "wechat_mp");
        if (null == config) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8bf7\u5148\u5b8c\u5584\u5fae\u4fe1\u516c\u4f17\u53f7\u51ed\u8bc1\u914d\u7f6e"));
        }
        JSONObject ticketJson = ThirdAuthUtil.createWechatMpTempTicket(ThirdAuthUtil.getWechatMpToken(busAccount, config), sb.toString(), 0);
        if (ticketJson.containsKey("errcode")) {
            String errmsg = ticketJson.getString("errmsg");
            if (CharSequenceUtil.isNotEmpty((CharSequence)errmsg) && errmsg.contains("invalid credential")) {
                ThirdAuthUtil.cleanThirdToken("wechat_mp", busAccount);
                ticketJson = ThirdAuthUtil.createWechatMpTempTicket(ThirdAuthUtil.getWechatMpToken(busAccount, config), sb.toString(), 0);
            } else {
                return Result.error((String)errmsg);
            }
        }
        String ticketStr = ticketJson.getString("ticket");
        TicketVO resultVO = new TicketVO();
        resultVO.setTicketUri("https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticketStr);
        resultVO.setExpireSeconds(ticketJson.getInteger("expire_seconds"));
        return Result.ok((Object)resultVO);
    }

    @Operation(summary="\u83b7\u53d6\u5355\u70b9\u767b\u5f55url", description="\u83b7\u53d6\u5355\u70b9\u767b\u5f55url")
    @GetMapping(value={"/getSsoUrl/{type}"})
    public Result<?> getSsoUrl(@PathVariable(value="type") String type, VoucherSsoVO vo) {
        String ssoUrl = ((ExternalVoucherService)this.service).getSsoUrl(TenantContext.getTenant(), type, vo);
        JSONObject obj = new JSONObject();
        obj.put((Object)"ssoUrl", (Object)ssoUrl);
        return Result.ok((Object)obj);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listParam"})
    @RequiresPermissions(value={"externalVoucher:list"})
    public Result<?> listParam(ExternalVoucherParam voucher, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)voucher), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)SrmUtil.getLoginUser().getElsAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.externalVoucherParamService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406", value="\u6dfb\u52a0\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @Operation(summary="\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u7ba1\u7406", description="\u6dfb\u52a0\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @PostMapping(value={"/paramAdd"})
    @RequiresPermissions(value={"externalVoucher:add"})
    public Result<?> paramAdd(@RequestBody ExternalVoucherParam param) {
        this.externalVoucherParamService.add(param);
        return Result.ok((Object)((Object)param));
    }

    @AutoLog(busModule="\u5f00\u653e\u63a5\u53e3\u5e94\u7528\u7ba1\u7406", value="\u7f16\u8f91\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @Operation(summary="\u5f00\u653e\u63a5\u53e3\u5e94\u7528\u7ba1\u7406", description="\u7f16\u8f91\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @PostMapping(value={"/paramEdit"})
    @RequiresPermissions(value={"externalVoucher:add"})
    public Result<?> paramEdit(@RequestBody ExternalVoucherParam param) {
        this.externalVoucherParamService.edit(param);
        return this.queryById(param.getId());
    }

    @AutoLog(busModule="\u5f00\u653e\u63a5\u53e3\u5e94\u7528\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @Operation(summary="\u5f00\u653e\u63a5\u53e3\u5e94\u7528\u7ba1\u7406", description="\u901a\u8fc7id\u5220\u9664\u62d3\u5c55\u53c2\u6570\u6821\u9a8c")
    @GetMapping(value={"/paramDelete"})
    @RequiresPermissions(value={"externalVoucher:add"})
    public Result<?> paramDelete(@RequestParam(name="id") String id) {
        this.externalVoucherParamService.delete(id);
        return this.commonSuccessResult();
    }
}

