/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.mapper.PurchaseAttachmentMapper;
import com.els.modules.attachment.mapper.SaleAttachmentMapper;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.utils.SignatureFilePath;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseAttachmentServiceImpl
extends ServiceImpl<PurchaseAttachmentMapper, PurchaseAttachment>
implements PurchaseAttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseAttachmentServiceImpl.class);
    @Autowired
    private SaleAttachmentMapper saleAttachmentMapper;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private SignatureFilePath signatureFilePath;

    @Override
    public void delPurchaseAttachment(String id) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseAttachment(List<String> idList) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void sendFile(AttachmentSendVO sendVO) {
        this.sendFile(sendVO, false);
    }

    @Override
    public void sendFile(AttachmentSendVO sendVO, boolean sendAllFlag) {
        String elsAccount = sendVO.getElsAccount();
        List<String> ignoreUploadType = sendVO.getIgnoreUploadType();
        List<PurchaseAttachment> attachmentList = ((PurchaseAttachmentMapper)this.baseMapper).selectByMainId(sendVO.getHeadId());
        List<PurchaseAttachment> needSendList = attachmentList.parallelStream().filter(attachment -> sendAllFlag || !"1".equals(attachment.getSendStatus())).filter(a -> CollectionUtil.isEmpty((Collection)ignoreUploadType) || !ignoreUploadType.contains(a.getUploadType())).filter(attachment -> elsAccount.equals(attachment.getUploadElsAccount())).collect(Collectors.toList());
        log.info("sendFile->getElsAccount:{}", (Object)elsAccount);
        log.info("needSendList:{}", (Object)JSONObject.toJSONString(needSendList));
        if (CollectionUtil.isEmpty(needSendList)) {
            return;
        }
        needSendList.forEach(attachment -> attachment.setSendStatus("1"));
        this.updateBatchById(needSendList);
        ArrayList<SaleAttachment> insertSaleList = new ArrayList<SaleAttachment>();
        Map<Object, Object> toSend = sendVO.getToSend() == null ? new ConcurrentHashMap() : sendVO.getToSend();
        for (String string : toSend.keySet()) {
            String saleElsAccount = (String)toSend.get(string);
            for (PurchaseAttachment purchaseAttachment : needSendList) {
                SaleAttachment saleAttachment = new SaleAttachment();
                BeanUtils.copyProperties((Object)((Object)purchaseAttachment), (Object)((Object)saleAttachment));
                saleAttachment.setId(IdWorker.getIdStr());
                saleAttachment.setElsAccount(saleElsAccount);
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setHeadId(string);
                insertSaleList.add(saleAttachment);
            }
        }
        if (!insertSaleList.isEmpty()) {
            SaleAttachmentService saleAttachmentService = (SaleAttachmentService)SpringContextUtils.getBean(SaleAttachmentService.class);
            log.info("insertSaleList:{}", (Object)JSONObject.toJSONString(insertSaleList));
            saleAttachmentService.saveBatch(insertSaleList);
        }
    }

    @Override
    public List<PurchaseAttachment> selectByMainId(String mainId) {
        return ((PurchaseAttachmentMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void deleteByMainIdAndBusinessType(String mainId, String businessType) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteByMainIdAndBusinessType(mainId, businessType);
    }

    @Override
    public String getSignature(String saveType, String filePath, String tempContextUrl) {
        return this.signatureFilePath.getSignature(saveType, filePath, this.uploadpath, tempContextUrl);
    }

    @Override
    public Map<String, List<PurchaseAttachmentDTO>> listPurchaseAttachmentListByMainId(List<String> headIds) {
        List<PurchaseAttachment> attachmentList = ((PurchaseAttachmentMapper)this.baseMapper).selectWithoutElsAccountToListPurchaseAttachmentList(headIds);
        List attachmentDTOS = Convert.toList(PurchaseAttachmentDTO.class, attachmentList);
        return attachmentDTOS.stream().collect(Collectors.groupingBy(PurchaseAttachmentDTO::getHeadId));
    }

    @Override
    public void updateSaleFile(AttachmentSendVO sendVO) {
        List<SaleAttachment> attachmentList = this.saleAttachmentMapper.selectByMainId(sendVO.getHeadId());
        log.info("AttachmentSendVO:{}", (Object)JSONObject.toJSONString((Object)sendVO));
        log.info("SaleAttachment:{}", (Object)JSONObject.toJSONString(attachmentList));
        if (attachmentList.isEmpty()) {
            return;
        }
        Map<String, String> sendMap = sendVO.getToSend();
        for (String id : sendMap.keySet()) {
            String elsAccount = sendMap.get(id);
            List list = attachmentList.stream().filter(o -> o.getUploadElsAccount().equals(elsAccount)).collect(Collectors.toList());
            for (SaleAttachment attachment : list) {
                attachment.setHeadId(id);
                this.saleAttachmentMapper.updateById((Object)attachment);
            }
        }
    }

    @Override
    public List<PurchaseAttachment> selectByMainIds(List<String> mainIds) {
        List<PurchaseAttachment> attachmentList = ((PurchaseAttachmentMapper)this.baseMapper).selectWithoutElsAccountToListPurchaseAttachmentList(mainIds);
        return attachmentList;
    }

    @Override
    public void deleteByMainIds(List<String> headIds) {
        if (headIds.isEmpty()) {
            return;
        }
        ((PurchaseAttachmentMapper)this.baseMapper).deleteByMainIds(headIds);
    }

    @Override
    @SrmValidated
    public boolean saveAttachment(PurchaseAttachment attachment) {
        return ((PurchaseAttachmentMapper)this.baseMapper).insert((Object)attachment) > 0;
    }
}

