/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.CodeGeneratorUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarCodeParamConfig;
import com.els.modules.barcode.enumerate.ElsBarCodeParamConfigEnum;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeParamConfigMapper;
import com.els.modules.barcode.service.ElsBarCodeParamConfigService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsBarCodeParamConfigServiceImpl
extends BaseServiceImpl<ElsBarCodeParamConfigMapper, ElsBarCodeParamConfig>
implements ElsBarCodeParamConfigService {
    @Resource
    ElsBarCodeParamConfigMapper configMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveElsBarCodeParamConfig(ElsBarCodeParamConfig elsBarCodeParamConfig) {
        elsBarCodeParamConfig.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        elsBarCodeParamConfig.setParamSerialNumber(CodeGeneratorUtil.getNextCode((String)"srmBarcodeParamNumber", (Object)((Object)elsBarCodeParamConfig)));
        elsBarCodeParamConfig.setDataVersion(0);
        int countNum = this.configMapper.countByDocType(null, elsBarCodeParamConfig.getBusDocType(), TenantContext.getTenant());
        AssertI18nUtil.isTrue((countNum > 0 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.PARAM_SAME_DOC_TYPE);
        if (StrUtil.isBlank((CharSequence)elsBarCodeParamConfig.getBusDocType())) {
            elsBarCodeParamConfig.setBusDocType(null);
            elsBarCodeParamConfig.setDefaultParam("1");
        } else {
            elsBarCodeParamConfig.setDefaultParam("0");
        }
        this.configMapper.insert((Object)elsBarCodeParamConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsBarCodeParamConfig(ElsBarCodeParamConfig elsBarCodeParamConfig) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)elsBarCodeParamConfig.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)elsBarCodeParamConfig.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        int countNum = this.configMapper.countByDocType(elsBarCodeParamConfig.getId(), elsBarCodeParamConfig.getBusDocType(), TenantContext.getTenant());
        AssertI18nUtil.isTrue((countNum > 0 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.PARAM_SAME_DOC_TYPE);
        ElsBarCodeParamConfig updateRecord = new ElsBarCodeParamConfig();
        BeanUtils.copyProperties((Object)((Object)elsBarCodeParamConfig), (Object)((Object)updateRecord));
        updateRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        if (StrUtil.isBlank((CharSequence)elsBarCodeParamConfig.getBusDocType())) {
            updateRecord.setBusDocType(null);
            updateRecord.setDefaultParam("1");
        } else {
            updateRecord.setDefaultParam("0");
        }
        int count = this.configMapper.updateById((Object)updateRecord);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    public void operaOn(String id) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        oldRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        ((ElsBarCodeParamConfigMapper)this.baseMapper).updateById((Object)oldRecord);
    }

    @Override
    public void operaOff(String id) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_OFF.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_OFF);
        oldRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_OFF.value());
        ((ElsBarCodeParamConfigMapper)this.baseMapper).updateById((Object)oldRecord);
    }

    @Override
    public void delElsBarCodeParamConfig(String id) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        ((ElsBarCodeParamConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsBarCodeParamConfig(List<String> idList) {
        for (String id : idList) {
            ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
            AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        }
        ((ElsBarCodeParamConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

