/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.service.ImInvokeGroupChatUserRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RpcService
public class ImInvokeGroupChatUserRpcServiceImpl
implements ImInvokeGroupChatUserRpcService {
    @Override
    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto groupChatRecordDto) {
        List imRecordVoList = ((GroupChatRecordUserRpcService)SrmRpcUtil.getExecuteServiceImpl((String)groupChatRecordDto.getRpcName(), GroupChatRecordUserRpcService.class)).loadGroupChatUserByRecord(groupChatRecordDto);
        if (CollUtil.isEmpty((Collection)imRecordVoList)) {
            return Lists.newArrayList();
        }
        Map<String, List<RecordUserDto>> distinctAccount = imRecordVoList.stream().collect(Collectors.groupingBy(RecordUserDto::getElsAccount));
        List<ElsSubAccount> imUsers = ((ImAccountLocalService)SrmRpcUtil.getExecuteServiceImpl(ImAccountLocalService.class)).listAccountByAccountAndSubAccount(distinctAccount.keySet());
        ArrayList result = Lists.newArrayList();
        for (ElsSubAccount u : imUsers) {
            String keyAccount = u.getElsAccount() + "_" + u.getSubAccount();
            String name = u.getElsAccount() + "_" + u.getRealname();
            if (!distinctAccount.containsKey(keyAccount)) continue;
            distinctAccount.get(keyAccount).forEach(x -> {
                RecordUserDto v = (RecordUserDto)Convert.convert(RecordUserDto.class, (Object)((Object)u));
                String username = CharSequenceUtil.isBlank((CharSequence)x.getGroupName()) ? "" : x.getGroupName() + "-";
                v.setRealname(username + name + (String)(CharSequenceUtil.isNotEmpty((CharSequence)v.getEnterpriseName()) ? "_" + v.getEnterpriseName() : ""));
                v.setGroupName(CharSequenceUtil.nullToDefault((CharSequence)x.getGroupName(), (String)""));
                v.setHeadPortrait(x.getHeadPortrait());
                result.add(v);
            });
        }
        result.sort(Comparator.comparing(RecordUserDto::getGroupName));
        return result;
    }
}

