/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import com.els.common.util.SpringContextUtils;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.entity.ElsMsgRecord;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.service.ElsMsgRecordService;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InternalMsgImpl
extends AbstractSendMsgImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("InternalMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u7ad9\u5185\u4fe1\u7684\u903b\u8f91.");
        try {
            ElsMsgConfigItem configItem = msg.getConfigItem();
            ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
            ElsSubAccount sendAccountInfo = msg.getSendAccountInfo();
            ElsMsgRecord record = new ElsMsgRecord();
            record.setElsAccount(receiveAccountInfo.getElsAccount());
            record.setSubAccount(receiveAccountInfo.getSubAccount());
            record.setReceiverId(receiveAccountInfo.getId());
            record.setReceiverName(receiveAccountInfo.getRealname());
            record.setSendId(sendAccountInfo.getId());
            record.setSendElsAccount(sendAccountInfo.getElsAccount());
            record.setSendSubAccount(sendAccountInfo.getSubAccount());
            record.setSendName(sendAccountInfo.getRealname());
            record.setSendTime(new Date());
            record.setBusinessType(msg.getBusinessType());
            record.setMsgConfigCode(msg.getMsgConfigCode());
            record.setMsgConfigName(msg.getMsgConfigName());
            record.setHandleFlag("0");
            String linkUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
            record.setLinkUrl(linkUrl);
            String msgTitle = this.parseContentTemplateText("", configItem.getMsgTitle(), (Map<String, Object>)msg.getBusinessObj());
            record.setMsgTitle(msgTitle);
            String msgContent = this.parseContentTemplateText("", configItem.getMsgContent(), (Map<String, Object>)msg.getBusinessObj());
            record.setMsgContent(msgContent);
            ElsMsgRecordService recordService = (ElsMsgRecordService)SpringContextUtils.getBean(ElsMsgRecordService.class);
            recordService.save((Object)record);
            log.info("InternalMsgImpl\u7ad9\u5185\u4fe1\u53d1\u9001\u5b8c\u6bd5");
        }
        catch (Exception e) {
            log.error("InternalMsgImpl\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.INTERNAL.getType();
    }

    @Override
    protected String getUrl(String urlParam, String busAccount, ElsSubAccount accountInfo) {
        return urlParam;
    }
}

