/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConfigUtil;
import com.els.common.util.ExternalUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.mapper.CompanyInterfaceConfigMapper;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyInterfaceConfigServiceImpl
extends BaseServiceImpl<CompanyInterfaceConfigMapper, CompanyInterfaceConfig>
implements CompanyInterfaceConfigService {
    private static final String REDIS_KEY = "sys:company:interface:";
    private static final String INTERFACE_LOGIN_URL = "/user/login";
    private static final String INTERFACE_REDIRECT = "&redirect=%2finterface%2finterfaceLog%2finterfaceLogList";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private SrmToIPaasService srmToIPaasService;

    private String getRedisKey(String elsAccount, String interfaceCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(interfaceCode);
        return redisKey.toString();
    }

    @Override
    public void updateCompanyInterfaceConfig(CompanyInterfaceConfig config) {
        ((CompanyInterfaceConfigMapper)this.baseMapper).updateById((Object)config);
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant(), config.getSrmInterfaceCode())});
    }

    @Override
    public IPage<CompanyInterfaceConfig> findPageList(Page<CompanyInterfaceConfig> page, QueryWrapper<CompanyInterfaceConfig> wrapper) {
        return ((CompanyInterfaceConfigMapper)this.baseMapper).findPageList(page, TenantContext.getTenant(), SysUtil.getPurchaseAccount(), wrapper);
    }

    @Override
    public CompanyInterfaceConfig getOneConfig(String elsAccount, String srmInterfaceCode) {
        CompanyInterfaceConfig config = (CompanyInterfaceConfig)((Object)this.redisUtil.get(this.getRedisKey(elsAccount, srmInterfaceCode)));
        if (config != null) {
            return config;
        }
        config = ((CompanyInterfaceConfigMapper)this.baseMapper).getOneConfig(elsAccount, SysUtil.getPurchaseAccount(), srmInterfaceCode);
        if (config != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, srmInterfaceCode), (Object)config, 4L);
        }
        return config;
    }

    @Override
    public String getSsoUrl(String elsAccount) {
        CompanyInterfaceConfigItemService companyInterfaceConfigItemService = (CompanyInterfaceConfigItemService)SpringContextUtils.getBean(CompanyInterfaceConfigItemService.class);
        List<CompanyInterfaceConfigItem> configItemList = companyInterfaceConfigItemService.getConfig(elsAccount, "getInterfaceSSOToken");
        if (configItemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuIdjyVERWSMWFKm_dc343971", (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a5\u53e3\u914d\u7f6e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01"));
        }
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getInterfaceSSOToken");
        JSONObject body = new JSONObject();
        body.put("elsAccount", (Object)elsAccount);
        body.put("subAccount", (Object)configItemList.get(0).getCustomParam());
        param.put("body", (Object)body);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, null, param, null);
        if (resultObj.getIntValue("code") == 200) {
            String token = resultObj.getJSONObject("result").getString("token");
            ExternalVoucherDto iPassVoucher = ExternalUtil.getVoucher((String)elsAccount, (String)"interface");
            StringBuilder resultUrl = new StringBuilder(iPassVoucher.getServiceUrl());
            resultUrl.append(INTERFACE_LOGIN_URL).append("?token=").append(token).append(INTERFACE_REDIRECT);
            return resultUrl.toString();
        }
        throw new ELSBootException(resultObj.getString("message"));
    }

    @Override
    public String getIpassSsoUrl(String elsAccount) {
        if (DeployWayEnum.SAAS.getValue().equals(SysUtil.getDeployWay())) {
            ExternalVoucherDto iPassVoucher = ExternalUtil.getVoucher((String)elsAccount, (String)"ipaas");
            if (iPassVoucher == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERIPASSUEUiVHDjKm_23a4054a", (String)"\u672a\u914d\u7f6eIPASS\u5e73\u53f0\u51ed\u8bc1\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01"));
            }
            return this.processIpassSsoUrl(iPassVoucher.getElsAccount(), iPassVoucher.getVoucherKey(), iPassVoucher.getServiceUrl());
        }
        ExternalVoucherDto iPassVoucher = ExternalUtil.getVoucher((String)ConfigUtil.getPurchaseAccount(), (String)"ipaas");
        String VoucherElsAccount = iPassVoucher.getVoucherKey().split("_")[0];
        String subAccount = iPassVoucher.getVoucherKey().substring(elsAccount.length() + 1);
        return this.processIpassSsoUrl(VoucherElsAccount, subAccount, iPassVoucher.getServiceUrl());
    }

    private String processIpassSsoUrl(String elsAccount, String subAccount, String ipassUrl) {
        JSONObject data = new JSONObject();
        data.put("currentAccount", (Object)elsAccount);
        data.put("subAccount", (Object)subAccount);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "ssoTokenServiceImpl");
        String ssoUrl = "";
        if (!result.getBoolean("success").booleanValue()) {
            throw new ELSBootException(result.getString("message"));
        }
        String token = result.getJSONObject("data").getString("token");
        StringBuilder resultUrl = new StringBuilder(ipassUrl);
        ssoUrl = resultUrl.append("user/login").append("?token=").append(token).toString();
        return ssoUrl;
    }

    @Override
    public void addBySys(CompanyInterfaceConfig invokeInterface) {
        CompanyInterfaceConfig dbInterface = (CompanyInterfaceConfig)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompanyInterfaceConfig::getSrmInterfaceCode, (Object)invokeInterface.getSrmInterfaceCode())).eq(ParentEntity::getElsAccount, (Object)this.getElsAccount())));
        if (dbInterface == null) {
            invokeInterface.setId(IdWorker.getIdStr());
            invokeInterface.setElsAccount(this.getElsAccount());
            SrmUtil.cleanBaseEntity((BaseEntity)invokeInterface);
            this.save((Object)invokeInterface);
        } else {
            dbInterface.setInterfaceName(invokeInterface.getInterfaceName());
            this.updateById((Object)dbInterface);
        }
    }
}

