/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.service.BusinessDeliverToRpcService;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.common.validator.ValidationUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountDeliverToService;
import com.els.modules.account.password.entity.PasswordUpdateRecord;
import com.els.modules.account.password.service.PasswordSecurityService;
import com.els.modules.account.password.service.PasswordUpdateRecordService;
import com.els.modules.account.password.vo.PasswordCheckResultVO;
import com.els.modules.account.platform.vo.ChangePhoneParamVO;
import com.els.modules.auth.service.LoginService;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.other.api.service.OtherRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.rpc.service.InvokeBusinessDeliverToRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.UserPermissionGroupService;
import com.els.modules.system.vo.ChangePasswordParamVO;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.system.vo.FrozenParamVO;
import com.els.modules.system.vo.PermissionVO;
import com.j256.twofactorauth.TimeBasedOneTimePasswordUtil;
import jakarta.annotation.Resource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsSubAccountServiceImpl
extends BaseOpenServiceImpl<ElsSubAccountMapper, ElsSubAccount, ElsSubAccount>
implements ElsSubAccountService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CommonAPI baseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PasswordSecurityService passwordSecurityService;
    @Autowired
    private PasswordUpdateRecordService passwordUpdateRecordService;
    @Resource
    private SubaccountOrgService subaccountOrgService;
    @Resource
    private UserPermissionGroupService userPermissionGroupService;
    @Resource
    private PersonalSettingService personalSettingService;
    private static final String ACCCOUNT_LIST_PREFIX = "sys:account:permisson:";
    private static final String ACCOUNT_INFO_REDIS_KEY = "srm:base:account:accountInfo:";

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> resetPassword(String subAccount, String oldpassword, String newpassword, String confirmpassword) {
        ElsSubAccount user = this.getByAccount(TenantContext.getTenant(), subAccount);
        String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)oldpassword, (String)user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_OwoWNNSW_29bef277", (String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!"));
        }
        if (ConvertUtils.isEmpty((Object)newpassword)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_VwoxiTLVW_5c8c5208", (String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RmWNwoxIR_5a67fad7", (String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!"));
        }
        String password = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)newpassword, (String)user.getSalt());
        ElsSubAccount update = new ElsSubAccount();
        update.setPassword(password);
        this.userMapper.update((Object)update, (Wrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)user.getId()));
        this.clearRedisCache(TenantContext.getTenant(), subAccount);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_wosRLRW_ca627356", (String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> changePassword(ElsSubAccount account) {
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = account.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        this.userMapper.updateById((Object)account);
        this.clearRedisCache(account.getElsAccount(), account.getSubAccount());
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_wocrLRW_1e3a7b4c", (String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public ElsSubAccount getUserBySubAccount(String subAccount) {
        return this.getByAccount(TenantContext.getTenant(), subAccount);
    }

    @Override
    public ElsSubAccount getUserByAccount(String account) {
        return this.getByAccount(account.split("_")[0], account.split("_")[1]);
    }

    @Override
    public List<ElsSubAccount> getAccountByRoles(String elsAccount, List<String> roles) {
        List<String> strings;
        if (CollectionUtil.isNotEmpty(roles) && CollectionUtil.isNotEmpty(strings = this.roleService.loadUserIdByElsAccountAndRoleCode(elsAccount, roles))) {
            List list1 = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ParentEntity::getId, strings)).list();
            return list1;
        }
        return null;
    }

    @Override
    @SrmTransaction
    public void addUserWithRole(ElsSubAccount user, String roles) {
        if (CharSequenceUtil.isEmpty((CharSequence)user.getFullName())) {
            user.setFullName(user.getRealname());
        }
        this.save((Object)user);
        this.insertRole(user, roles);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction
    public void editUserWithRole(ElsSubAccount user, String roles) {
        List roleList = this.roleService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ParentEntity::getElsAccount, (Object)user.getElsAccount())).eq(Role::getRoleCode, (Object)"companyAdmin"));
        Assert.notEmpty((Collection)roleList, (String)I18nUtil.translate((String)"i18n_alert_AEslTMKRvjWWWWWWKy_e43c1dd7", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458[${0}]\u89d2\u8272", (String[])new String[]{"companyAdmin"}));
        String roleId = ((Role)((Object)roleList.get(0))).getId();
        if (!("," + roles + ",").contains("," + roleId + ",")) {
            List userRoles = this.userRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(UserRole::getRoleId, (Object)roleId));
            Assert.notEmpty((Collection)userRoles, (String)I18nUtil.translate((String)"i18n_alert_AEslTMKRvjWWWWWWKy_325f6a36", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272"));
        }
        this.updateById((Object)user);
        this.userRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)user.getId()));
        this.redisUtil.del(new String[]{"ELSACCOUNT_SUBACCOUNT" + user.getElsAccount() + user.getSubAccount()});
        this.redisUtil.deleteByPrex(ACCCOUNT_LIST_PREFIX);
        this.insertRole(user, roles);
        this.redisUtil.del(new String[]{this.getRedisKey(user.getId())});
    }

    private void insertRole(ElsSubAccount user, String roles) {
        if (ConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                UserRole userRole = new UserRole(user.getId(), roleId);
                this.userRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        List<String> roles = this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------account\uff1a " + elsAccount + "_" + subAccount + ",Roles size: " + roles.size());
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<PermissionVO> permissionList = null;
        String deployWay = SysUtil.getDeployWay();
        permissionList = "cloud".equals(deployWay) ? this.permissionMapper.queryByAccount(elsAccount, subAccount, 0) : this.permissionMapper.queryLocalByAccount(elsAccount, subAccount);
        for (PermissionVO po : permissionList) {
            if (!ConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            if (po.getPerms().contains(";")) {
                List<String> itemList = Arrays.asList(po.getPerms().split(";"));
                permissionSet.addAll(itemList);
                continue;
            }
            permissionSet.add(po.getPerms());
        }
        return permissionSet;
    }

    @Override
    public void accountFreezeJob() {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSubAccount::getStatus, (Object)2)).le(ElsSubAccount::getAccountValidityDate, (Object)new Date())).isNotNull(ElsSubAccount::getAccountValidityDate)).update((Object)new ElsSubAccount());
    }

    @Override
    public ElsSubAccount getUserByPhone(String phone) {
        List accountList = this.list((Wrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getPhone, (Object)phone));
        if (accountList.isEmpty()) {
            return null;
        }
        return (ElsSubAccount)((Object)accountList.get(0));
    }

    @Override
    public ElsSubAccount getUserByEmail(String email) {
        List accountList = this.list((Wrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getEmail, (Object)email));
        if (accountList.isEmpty()) {
            return null;
        }
        return (ElsSubAccount)((Object)accountList.get(0));
    }

    public Result<?> checkUserIsEffective(ElsSubAccount account) {
        Result result = new Result();
        if (account == null) {
            result.error500(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(account.getDeleted())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u6ce8\u9500\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIdXW_d3c8a06b", (String)"\u8be5\u7528\u6237\u5df2\u6ce8\u9500"));
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3"));
            return result;
        }
        return result;
    }

    private String getAccountRedisKey(String elsAccount, String subAccount) {
        return ACCOUNT_INFO_REDIS_KEY + elsAccount + ":" + subAccount;
    }

    @Override
    public ElsSubAccount getByAccount(String elsAccount, String subAccount) {
        String redisKey = this.getAccountRedisKey(elsAccount, subAccount);
        ElsSubAccount accountInfo = (ElsSubAccount)((Object)this.redisUtil.get(redisKey));
        if (accountInfo != null) {
            return accountInfo;
        }
        accountInfo = (ElsSubAccount)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount)));
        if (accountInfo != null) {
            this.redisUtil.set(redisKey, (Object)accountInfo);
        }
        return accountInfo;
    }

    @Override
    @SrmTransaction
    public void deliverTo(String sourceAccountId, String targetAccountId, String businessDeliverToType) {
        String[] deliverToTypes;
        for (String type : deliverToTypes = businessDeliverToType.split(",")) {
            if ("todo".equals(type)) {
                this.workTodoDeliverTo(sourceAccountId, targetAccountId);
                continue;
            }
            BusinessDeliverToRpcService rpcService = ((InvokeBusinessDeliverToRpcService)SpringContextUtils.getBean(InvokeBusinessDeliverToRpcService.class)).getRpcService(type);
            rpcService.workDeliverTo(sourceAccountId, targetAccountId);
        }
    }

    private void workTodoDeliverTo(String sourceAccountId, String targetAccountId) {
        ElsSubAccount sourceAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)sourceAccountId)));
        ElsSubAccount targetAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)targetAccountId)));
        String[] beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AccountDeliverToService.class);
        ElsSubAccountDTO sourceAccountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)sourceAccount), ElsSubAccountDTO.class);
        ElsSubAccountDTO targetAccountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)targetAccount), ElsSubAccountDTO.class);
        for (String bean : beans) {
            AccountDeliverToService service = (AccountDeliverToService)SpringContextUtils.getBean((String)bean, AccountDeliverToService.class);
            service.deliverTo(sourceAccountDTO, targetAccountDTO);
        }
    }

    @Override
    public List<ElsSubAccount> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        ArrayList elsAccountList = new ArrayList();
        ArrayList subAccountList = new ArrayList();
        if (CollectionUtil.isEmpty(elsSubAccountList)) {
            return new ArrayList<ElsSubAccount>();
        }
        elsSubAccountList.forEach(item -> {
            elsAccountList.add(item.split("_")[0]);
            subAccountList.add(item.split("_")[1]);
        });
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ParentEntity::getElsAccount, elsAccountList)).in(ElsSubAccount::getSubAccount, subAccountList));
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getAccount", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List elsSubAccountList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (ElsSubAccount subAccount : elsSubAccountList) {
            this.pushDataToErp(subAccount);
        }
    }

    private void pushDataToErp(ElsSubAccount elsSubAccount) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushAccount", (Object)elsSubAccount);
    }

    private List<String> recursionQuery(List<String> resultList, String elsAccount, String subAccount) {
        List itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).likeRight((Object)"superior_leader", (Object)subAccount));
        if (!itemList.isEmpty()) {
            for (ElsSubAccount item : itemList) {
                if (resultList.contains(item.getSubAccount())) continue;
                resultList.add(item.getSubAccount());
                this.recursionQuery(resultList, elsAccount, item.getSubAccount());
            }
        }
        return resultList;
    }

    @Override
    public List<String> getAccountListByLeader(String elsAccount, String subAccount) {
        ArrayList<String> resultList = (ArrayList<String>)this.redisUtil.get(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount);
        if (resultList != null) {
            return resultList;
        }
        resultList = new ArrayList<String>();
        resultList.add(subAccount);
        this.recursionQuery(resultList, elsAccount, subAccount);
        this.redisUtil.set(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount, resultList);
        return resultList;
    }

    @Override
    public String getOtpQr(String elsAccount, String subAccount) {
        ElsSubAccount account = this.getByAccount(elsAccount, subAccount);
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eyxMK_a03c8815", (String)"\u8d26\u53f7\u4e0d\u5b58\u5728\uff01"));
        }
        String secret = account.getSecret();
        if (StrUtil.isBlank((CharSequence)secret)) {
            secret = TimeBasedOneTimePasswordUtil.generateBase32Secret((int)32);
            ElsSubAccount update = new ElsSubAccount();
            update.setSecret(secret);
            update.setId(account.getId());
            this.updateById((Object)update);
        }
        return this.createQr(elsAccount, subAccount, secret);
    }

    @Override
    public String resetOtpQr(String elsAccount, String subAccount) {
        ElsSubAccount account = this.getByAccount(elsAccount, subAccount);
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eyxMK_a03c8815", (String)"\u8d26\u53f7\u4e0d\u5b58\u5728\uff01"));
        }
        String secret = TimeBasedOneTimePasswordUtil.generateBase32Secret((int)32);
        ElsSubAccount update = new ElsSubAccount();
        update.setSecret(secret);
        update.setId(account.getId());
        this.updateById((Object)update);
        return this.createQr(elsAccount, subAccount, secret);
    }

    @Override
    public IPage<ElsSubAccount> selectWithoutElsAccountToSelectSubAccount(QueryWrapper<ElsSubAccount> queryWrapper, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        return pageList;
    }

    private String createQr(String elsAccount, String subAccount, String secret) {
        String otpauth = "otpauth://totp/" + elsAccount + "_" + subAccount + "?secret=" + secret + "&digits=6";
        BufferedImage image = QrCodeUtil.generate((String)otpauth, (int)300, (int)300);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            log.error("createQr_failed:", (Throwable)e);
        }
        String base64 = Base64.encode((byte[])stream.toByteArray());
        return "data:image/png;base64," + base64;
    }

    @Override
    public void checkTanentParam(String elsAccount, Integer count) {
        log.info("current_deploy_way:" + SysUtil.getDeployWay());
        if ("local".equals(SysUtil.getDeployWay())) {
            return;
        }
        com.alibaba.fastjson2.JSONObject body = new com.alibaba.fastjson2.JSONObject();
        body.put((Object)"elsAccount", (Object)elsAccount);
        body.put((Object)"paramCode", (Object)"SubAccountLimitCount");
        com.alibaba.fastjson2.JSONObject result = ((OtherRpcService)SrmRpcUtil.getExecuteServiceImpl(OtherRpcService.class)).callPanshi("getTenantParam", body);
        log.info("callPanshi_result:" + result.toJSONString(new JSONWriter.Feature[0]));
        if (result.getIntValue("code") != 200) {
            return;
        }
        String checkParam = result.getString("result");
        if ("unlimit".equals(checkParam)) {
            return;
        }
        long currentCount = this.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        log.info("current_subAccount_count:" + currentCount);
        int limitCount = Integer.valueOf(checkParam);
        if ((currentCount += (long)count.intValue()) > (long)limitCount) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tkKmAPqjeyWRBGefeyWWRefeyWL0_958deb38", (String)"\u64cd\u4f5c\u5931\u8d25\uff01\u5f53\u524d\u53ef\u7528\u8d26\u53f7\u6570\u91cf\u8d85\u51fa\u6700\u5927\u8d26\u53f7\u6570\u9650\u5236\uff0c\u6700\u5927\u8d26\u53f7\u6570\u4e3a\uff1a${0}", (String[])new String[]{"" + limitCount}));
        }
    }

    @Override
    public IPage<ElsSubAccountVO> selectSubAccountAndEnterprisePage(Page<ElsSubAccountVO> page, QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterprisePage(page, queryWrapper);
    }

    @Override
    public List<ElsSubAccountVO> selectSubAccountAndEnterpriseList(QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterpriseList(queryWrapper);
    }

    @Override
    public long selectSubAccountAndEnterpriseCount(QueryWrapper<ElsSubAccountVO> queryWrapper) {
        return ((ElsSubAccountMapper)this.baseMapper).selectSubAccountAndEnterpriseCount(queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean createUserIfNotExist(ElsSubAccount account) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)account.getElsAccount());
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{ParentEntity::getId});
            ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)account.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)account.getSubAccount());
            ElsSubAccount elsSubAccount = (ElsSubAccount)((Object)((ElsSubAccountMapper)this.baseMapper).selectOne((Wrapper)wrapper));
            if (null != elsSubAccount) {
                account.setId(elsSubAccount.getId());
                Boolean bl = true;
                return bl;
            }
            this.save((Object)account);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            } else {
                TenantContext.clear();
            }
        }
    }

    @Override
    public IPage<ElsSubAccount> pageWithUserId(Page<ElsSubAccount> page, QueryWrapper<ElsSubAccount> queryWrapper, String selectedroles) {
        if (StrUtil.isEmpty((CharSequence)selectedroles)) {
            return ((ElsSubAccountMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        }
        List roleIds = StrUtil.split((CharSequence)selectedroles, (CharSequence)",");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(UserRole::getRoleId, (Collection)roleIds);
        List userRoles = this.userRoleMapper.selectList((Wrapper)wrapper);
        if (userRoles.isEmpty()) {
            return new Page();
        }
        List userIds = userRoles.stream().map(UserRole::getUserId).collect(Collectors.toList());
        queryWrapper.lambda().in(ParentEntity::getId, userIds);
        return ((ElsSubAccountMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public List<LoginUserDTO> chatBiListAccount(LoginUserDTO user) {
        user.setElsAccount(null);
        ElsSubAccount convert = (ElsSubAccount)((Object)Convert.convert(ElsSubAccount.class, (Object)user));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)convert), new HashMap());
        List list = ((ElsSubAccountMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        for (ElsSubAccount account : list) {
            account.setPassword(null);
            account.setSalt(null);
        }
        return Convert.toList(LoginUserDTO.class, (Object)list);
    }

    private String getRedisKey(String id) {
        StringBuilder builder = new StringBuilder("srm:account:subAccount:");
        builder.append(id);
        return builder.toString();
    }

    @Override
    public ElsSubAccount getSubAccountById(String id) {
        String redisKey = this.getRedisKey(id);
        ElsSubAccount account = (ElsSubAccount)((Object)this.redisUtil.get(redisKey));
        if (account != null) {
            return account;
        }
        account = (ElsSubAccount)((Object)this.getById((Serializable)((Object)id)));
        this.redisUtil.set(redisKey, (Object)account);
        return account;
    }

    @Override
    public LoginUserDTO getLoginUserByAccount(String elsAccount, String subAccount) {
        ElsSubAccount account = this.getByAccount(elsAccount, subAccount);
        if (account == null) {
            return null;
        }
        LoginUserDTO loginUser = new LoginUserDTO();
        BeanUtils.copyProperties((Object)((Object)account), (Object)loginUser);
        ElsEnterpriseInfo enterpriseInfo = ((ElsEnterpriseInfoService)SpringContextUtils.getBean(ElsEnterpriseInfoService.class)).getByElsAccount(elsAccount);
        if (null != enterpriseInfo) {
            loginUser.setCompanyName(enterpriseInfo.getName());
            loginUser.setCompanyLogo(enterpriseInfo.getEnterpriseLogo());
            loginUser.setEnterpriseName(enterpriseInfo.getName());
            loginUser.setCompanyShortName(enterpriseInfo.getAlias());
        }
        JSONObject companySet = ((BaseRpcService)SrmRpcUtil.getExecuteServiceImpl(BaseRpcService.class)).getParamObj(elsAccount);
        loginUser.setCompanySet(companySet);
        return loginUser;
    }

    @Override
    public void clearRedisCache(String elsAccount, String subAccount) {
        this.redisUtil.del(new String[]{this.getAccountRedisKey(elsAccount, subAccount)});
        this.redisUtil.dels(JwtUtil.getTokenRedisKeyPrefix((String)elsAccount, (String)subAccount));
        this.redisUtil.del(new String[]{((LoginService)SpringContextUtils.getBean(LoginService.class)).getAccountLockRedisKey(elsAccount, subAccount)});
    }

    @Override
    @Transactional
    public void updateMain(JSONObject jsonObject) {
        ElsSubAccount sysUser = (ElsSubAccount)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)jsonObject.getString("id"))).eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())));
        if (sysUser == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        ValidationUtil.validateForObject((Object)((Object)user));
        user.setUpdateTime(new Date());
        user.setSalt(sysUser.getSalt());
        user.setStatus(sysUser.getStatus());
        user.setPassword(sysUser.getPassword());
        String roles = jsonObject.getString("selectedroles");
        if (StrUtil.isBlank((CharSequence)roles)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KyxOLV_81e5c6f0", (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.editUserWithRole(user, roles);
        this.saveUserPermissionGroup(user.getId(), jsonObject.getString("selectedGroups"));
        this.subaccountOrgService.deleteByMainId(sysUser.getId());
        List<SubaccountOrg> subaccountOrgList = user.getSubaccountOrgList();
        if (subaccountOrgList != null && subaccountOrgList.size() > 0) {
            subaccountOrgList.forEach(org -> {
                org.setId(null);
                org.setUserId(user.getId());
                org.setUserName(user.getRealname());
            });
            this.subaccountOrgService.saveBatch(subaccountOrgList, 2000);
        }
        this.redisUtil.del(new String[]{"sys:org:user:" + user.getId()});
        RedisKeyUtil.clearAccountOrgListRedisCache((String)user.getId());
        RedisKeyUtil.clearOrgInfoListRedisCache((String)user.getElsAccount());
        String redisKey = this.getAccountRedisKey(user.getElsAccount(), user.getSubAccount());
        this.redisUtil.del(new String[]{redisKey});
    }

    private void saveUserPermissionGroup(String userId, String groups) {
        String[] groupArray;
        this.redisUtil.del(new String[]{"sys:permissionData:group:" + userId});
        this.userPermissionGroupService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        if (StrUtil.isBlank((CharSequence)groups)) {
            return;
        }
        ArrayList<UserPermissionGroup> list = new ArrayList<UserPermissionGroup>();
        for (String groupId : groupArray = groups.split(",")) {
            UserPermissionGroup group = new UserPermissionGroup();
            group.setUserId(userId);
            group.setGroupId(groupId);
            list.add(group);
        }
        this.userPermissionGroupService.saveBatch(list);
    }

    @Override
    @Transactional
    public ElsSubAccount saveMain(JSONObject jsonObject) {
        String selectedRoles = jsonObject.getString("selectedroles");
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        this.checkTanentParam(TenantContext.getTenant(), 1);
        ValidationUtil.validateForObject((Object)((Object)user));
        ElsSubAccount sysUser = this.getUserBySubAccount(user.getSubAccount());
        if (sysUser != null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyIOMKW_d8bcd3b3", (String)"\u5b50\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        user.setElsAccount(TenantContext.getTenant());
        String salt = ConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + user.getSubAccount()), (String)user.getPassword(), (String)salt);
        user.setPassword(passwordEncode);
        user.setStatus(1);
        this.addUserWithRole(user, selectedRoles);
        this.saveUserPermissionGroup(user.getId(), jsonObject.getString("selectedGroups"));
        List<SubaccountOrg> subaccountOrgList = user.getSubaccountOrgList();
        if (subaccountOrgList != null && subaccountOrgList.size() > 0) {
            subaccountOrgList.forEach(org -> {
                org.setId(null);
                org.setUserId(user.getId());
                org.setUserName(user.getRealname());
            });
            this.subaccountOrgService.saveBatch(subaccountOrgList, 2000);
        }
        this.redisUtil.del(new String[]{"sys:org:user:" + user.getId()});
        this.insertPersonalSetting(user);
        RedisKeyUtil.clearOrgInfoListRedisCache((String)user.getElsAccount());
        return user;
    }

    private void insertPersonalSetting(ElsSubAccount user) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(user.getElsAccount());
            personalSetting.setSubAccount(user.getSubAccount());
            personalSetting.setCreateBy(user.getCreateBy());
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy(user.getUpdateBy());
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        this.personalSettingService.saveBatch(personalSettings);
    }

    @Override
    @Transactional
    public ElsSubAccount addOther(JSONObject jsonObject) {
        String selectedRoles = jsonObject.getString("selectedroles");
        String elsAccount = jsonObject.getString("elsAccount");
        this.checkTanentParam(elsAccount, 1);
        ElsSubAccount user = (ElsSubAccount)((Object)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class));
        ValidationUtil.validateForObject((Object)((Object)user));
        ElsSubAccount sysUser = this.getUserByAccount(elsAccount + "_" + user.getSubAccount());
        if (sysUser != null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyIOMKW_d8bcd3b3", (String)"\u5b50\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        String salt = ConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + user.getSubAccount()), (String)user.getPassword(), (String)salt);
        user.setPassword(passwordEncode);
        user.setStatus(1);
        this.addUserWithRole(user, selectedRoles);
        this.insertPersonalSetting(user);
        return user;
    }

    @Override
    @Transactional
    public void changePassword(ChangePasswordParamVO paramVO) {
        PasswordCheckResultVO resultVO = this.passwordSecurityService.checkPassword(paramVO.getElsAccount(), paramVO.getConfirmPassword());
        if (!resultVO.getCheckResult().booleanValue()) {
            throw new ELSBootException(resultVO.getErrorMessage());
        }
        ElsSubAccount accountInfo = (ElsSubAccount)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)paramVO.getId())).eq(ParentEntity::getElsAccount, (Object)paramVO.getElsAccount())));
        if (accountInfo == null) {
            throw new ELSBootException("\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\uff01");
        }
        String passwordEncode = PasswordUtil.encrypt((String)(accountInfo.getElsAccount() + "_" + accountInfo.getSubAccount()), (String)paramVO.getConfirmPassword(), (String)accountInfo.getSalt());
        if (resultVO.getForcePwdHis() != null && resultVO.getForcePwdHis() != 0) {
            this.passwordUpdateRecordService.checkPassword(accountInfo.getId(), passwordEncode, resultVO.getForcePwdHis());
        }
        ElsSubAccount updateInfo = new ElsSubAccount();
        updateInfo.setId(accountInfo.getId());
        updateInfo.setPassword(passwordEncode);
        this.updateById((Object)updateInfo);
        PasswordUpdateRecord updateRecord = new PasswordUpdateRecord();
        updateRecord.setAccountId(accountInfo.getId());
        updateRecord.setPassword(passwordEncode);
        updateRecord.setElsAccount(accountInfo.getElsAccount());
        updateRecord.setRealname(accountInfo.getRealname());
        updateRecord.setSubAccount(accountInfo.getSubAccount());
        updateRecord.setRecordTime(new Date());
        this.passwordUpdateRecordService.save((Object)updateRecord);
        this.redisUtil.del(new String[]{this.getAccountRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount())});
        this.redisUtil.dels(JwtUtil.getTokenRedisKeyPrefix((String)accountInfo.getElsAccount(), (String)accountInfo.getSubAccount()));
        this.redisUtil.del(new String[]{((LoginService)SpringContextUtils.getBean(LoginService.class)).getAccountLockRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount())});
    }

    @Override
    public void frozen(FrozenParamVO paramVO) {
        if (paramVO.getId().equals(SrmUtil.getLoginUser().getId())) {
            throw new ELSBootException("\u4e0d\u80fd\u5bf9\u81ea\u5df1\u8d26\u53f7\u8fdb\u884c\u51bb\u7ed3/\u89e3\u51bb\u64cd\u4f5c\uff01");
        }
        ElsSubAccount accountInfo = (ElsSubAccount)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)paramVO.getId())).eq(ParentEntity::getElsAccount, (Object)paramVO.getElsAccount())));
        if (accountInfo == null) {
            throw new ELSBootException("\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\uff01");
        }
        ElsSubAccount updateInfo = new ElsSubAccount();
        updateInfo.setId(accountInfo.getId());
        updateInfo.setStatus(paramVO.getStatus());
        this.updateById((Object)updateInfo);
        String redisKey = this.getAccountRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        this.redisUtil.del(new String[]{redisKey});
        if (paramVO.getStatus() == 2) {
            this.redisUtil.dels(JwtUtil.getTokenRedisKeyPrefix((String)accountInfo.getElsAccount(), (String)accountInfo.getSubAccount()));
        }
    }

    @Override
    public void changePhone(ChangePhoneParamVO paramVO) {
        ElsSubAccount accountInfo = (ElsSubAccount)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)paramVO.getId())).eq(ParentEntity::getElsAccount, (Object)paramVO.getElsAccount())));
        if (accountInfo == null) {
            throw new ELSBootException("\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\uff01");
        }
        ElsSubAccount updateInfo = new ElsSubAccount();
        updateInfo.setId(accountInfo.getId());
        updateInfo.setPhone(paramVO.getMobilePhone());
        this.updateById((Object)updateInfo);
        String redisKey = this.getAccountRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public List<String> queryAllSubAccount(List<String> elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(ParentEntity::getElsAccount, elsAccount)).eq(ElsSubAccount::getStatus, (Object)"1");
        wrapper.select(new SFunction[]{ParentEntity::getElsAccount, ElsSubAccount::getSubAccount});
        return ((ElsSubAccountMapper)this.baseMapper).selectList((Wrapper)wrapper).stream().map(x -> x.getElsAccount() + "_" + x.getSubAccount()).distinct().collect(Collectors.toList());
    }
}

