/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.third.sql.util.OracleSqlUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService
public class GetSubAccountFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetSubAccountFromCQGTOracleDbImpl.class);
    private String DEFAULT_VALUE = "123456";
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_USER_MESSAGE";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetSubAccountFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray ItemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        String elsAccount = TenantContext.getTenant();
        ArrayList<ElsSubAccount> insertAccount = new ArrayList<ElsSubAccount>();
        ArrayList<ElsSubAccount> updateAccount = new ArrayList<ElsSubAccount>();
        Map dept = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCateCode(elsAccount, "dept").stream().collect(Collectors.toMap(PurchaseOrganizationInfoDTO::getOrgName, Function.identity(), (newVal, oldVal) -> oldVal));
        Map subAccountMap = this.elsSubAccountService.list().stream().collect(Collectors.toMap(ElsSubAccount::getSubAccount, Function.identity(), (newVal, oldVal) -> oldVal));
        for (Object object : ItemList) {
            JSONObject item = (JSONObject)object;
            String subAccount = item.getString("USER_ACCOUNT");
            String realname = item.getString("USER_NAME");
            String orgCode = item.getString("USER_DEPT");
            String id = item.getString("USER_ID");
            String workNo = item.getString("USER_NUM");
            String updateTime = item.getString("UPDATE_TIME");
            ElsSubAccount elsSubAccount = new ElsSubAccount();
            if (subAccountMap.containsKey(subAccount)) {
                elsSubAccount.setWorkNo(workNo);
                elsSubAccount.setRealname(realname);
                elsSubAccount.setSubAccount(subAccount);
                if (dept.containsKey(orgCode)) {
                    PurchaseOrganizationInfoDTO orgCode1 = (PurchaseOrganizationInfoDTO)dept.get(orgCode);
                    elsSubAccount.setDeptId(orgCode1.getId());
                }
                updateAccount.add(elsSubAccount);
                continue;
            }
            elsSubAccount.setId(IdWorker.getIdStr());
            elsSubAccount.setWorkNo(workNo);
            elsSubAccount.setRealname(realname);
            elsSubAccount.setSubAccount(subAccount);
            String salt = ConvertUtils.randomGen((int)8);
            elsSubAccount.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount), (String)this.DEFAULT_VALUE, (String)elsSubAccount.getSalt());
            elsSubAccount.setPassword(passwordEncode);
            if (dept.containsKey(orgCode)) {
                PurchaseOrganizationInfoDTO orgCode1 = (PurchaseOrganizationInfoDTO)dept.get(orgCode);
                elsSubAccount.setDeptId(orgCode1.getId());
            }
            elsSubAccount.setSourceId(id);
            elsSubAccount.setSourceType("THIRD");
            elsSubAccount.setSourceSystem("ORACLE");
            elsSubAccount.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
            insertAccount.add(elsSubAccount);
        }
        if (CollectionUtil.isNotEmpty(insertAccount)) {
            this.elsSubAccountService.saveBatch(insertAccount, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateAccount)) {
            this.elsSubAccountService.updateBatchById(updateAccount, 2000);
        }
        return interfaceResult;
    }
}

