/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SrmUtil;
import com.els.modules.todo.entity.WorkstationConfigAccount;
import com.els.modules.todo.mapper.WorkstationConfigAccountMapper;
import com.els.modules.todo.service.WorkstationConfigAccountService;
import com.els.modules.todo.vo.WorkstationConfigVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkstationConfigAccountServiceImpl
extends BaseServiceImpl<WorkstationConfigAccountMapper, WorkstationConfigAccount>
implements WorkstationConfigAccountService {
    @Override
    @Transactional
    public void save(List<WorkstationConfigVO> configList) {
        String accountId = SrmUtil.getLoginUser().getId();
        ((WorkstationConfigAccountMapper)this.baseMapper).deleteByUserId(accountId);
        ArrayList<WorkstationConfigAccount> insertList = new ArrayList<WorkstationConfigAccount>();
        BigDecimal sortNo = BigDecimal.ONE;
        for (WorkstationConfigVO config : configList) {
            if (!"1".equals(config.getSelected())) continue;
            WorkstationConfigAccount insert = new WorkstationConfigAccount();
            insert.setElsAccount(this.getElsAccount());
            insert.setAccountId(accountId);
            insert.setWorkstationId(config.getId());
            insert.setSortNo(sortNo);
            sortNo = sortNo.add(BigDecimal.ONE);
            insertList.add(insert);
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.saveBatch(insertList);
        }
    }
}

