/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.translate.config;

import com.els.modules.translate.util.TencentUtils;
import com.tencentcloudapi.asr.v20190614.AsrClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="els.tencent.translate", name={"enable"}, havingValue="true", matchIfMissing=false)
@ConfigurationProperties(prefix="els.tencent.translate")
public class TencentConfig {
    private String secretId;
    private String secretKey;

    @Bean
    public TencentUtils tencentUtils(AsrClient asrClient) {
        return new TencentUtils(asrClient);
    }

    @Bean
    public AsrClient asrClient() {
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("asr.tencentcloudapi.com");
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        return new AsrClient(new Credential(this.secretId, this.secretKey), "ap-guangzhou", clientProfile);
    }

    @Generated
    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    @Generated
    public String getSecretId() {
        return this.secretId;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }
}

