/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.config.ImConfig;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.HandlerManager;
import com.els.modules.im.core.server.handler.OptHandler;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.server.handler.IWsMsgHandler;

@Component(value="wsMsgHandler")
public class WsMsgHandler
implements IWsMsgHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WsMsgHandler.class);
    @Autowired
    protected ImConfig srmImConfig;
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;

    public HttpResponse handshake(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        String token = request.getParam("token");
        ImUserPackets loginUser = this.srmBusinessHelper.loadLoginUser(token);
        this.srmBusinessHelper.connectInit(channelContext, loginUser);
        return httpResponse;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        List<ImUserPackets> friendsRequest = this.srmBusinessHelper.getUserFriendsRequest(channelContext.userid);
        if (CollectionUtils.isNotEmpty(friendsRequest)) {
            WsResultPackets wsResult = new WsResultPackets();
            wsResult.setMsgType(WsMsgTypePackets.ADD_FRIEND_REQUEST.getMsgType());
            wsResult.setData(friendsRequest);
            WsResponse toWsResponse = WsResponse.fromText((String)WsResultPackets.toJsonString(wsResult), (String)"UTF-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        return null;
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        ImSender.unbindUser(channelContext.userid, channelContext.getTioConfig());
        ImSender.unbindGroup(channelContext);
        this.srmBusinessHelper.removeThisOnline(channelContext.userid, TioConfigConstant.SERVER_ID);
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) throws Exception {
        try {
            WsMessagePackets wsMessage = (WsMessagePackets)JSON.parseObject((String)text, WsMessagePackets.class);
            String code = wsMessage.getConnCode();
            if (CharSequenceUtil.isEmpty((CharSequence)code)) {
                throw new ELSBootException(I18nUtil.translate((String)"\u8fde\u63a5\u72b6\u6001\u7801\u4e0d\u652f\u6301"));
            }
            OptHandler optHandler = HandlerManager.execHandler(code);
            if (null == optHandler) {
                throw new ELSBootException(I18nUtil.translate((String)"\u8fde\u63a5\u72b6\u6001\u7801\u4e0d\u652f\u6301"));
            }
            return optHandler.handler(wsRequest, wsMessage, channelContext);
        }
        catch (Exception e) {
            log.error("\u804a\u5929\u6d88\u606f\u5904\u7406\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }
}

