/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.password.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.ConfigUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.password.entity.PasswordSecurity;
import com.els.modules.account.password.service.PasswordSecurityService;
import com.els.modules.account.password.vo.PasswordCheckParamVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5bc6\u7801\u5b89\u5168\u7b56\u7565\u7ba1\u7406")
@RestController
@RequestMapping(value={"/base/passwordSecurity"})
public class PasswordSecurityController
extends BaseController<PasswordSecurity, PasswordSecurityService> {
    @Autowired
    private PasswordSecurityService passwordSecurityService;

    @AutoLog(busModule="\u5bc6\u7801\u5b89\u5168\u7b56\u7565\u7ba1\u7406", value="\u4fdd\u5b58")
    @Operation(summary="\u4fdd\u5b58", description="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"passwordSecurity:save"})
    public Result<?> save(@RequestBody PasswordSecurity passwordSecurity) {
        this.passwordSecurityService.saveSecurity(passwordSecurity);
        return this.commonSuccessResult();
    }

    @Operation(summary="\u67e5\u8be2\u5f53\u524d\u8d26\u53f7\u914d\u7f6e", description="\u67e5\u8be2\u5f53\u524d\u8d26\u53f7\u914d\u7f6e")
    @GetMapping(value={"/queryByCurrentAccount"})
    @RequiresPermissions(value={"passwordSecurity:view"})
    public Result<?> queryByCurrentAccount() {
        PasswordSecurity passwordSecurity = this.passwordSecurityService.getByElsAccount(this.getElsAccount());
        return Result.ok((Object)((Object)passwordSecurity));
    }

    @Operation(summary="\u5bc6\u7801\u6821\u9a8c", description="\u5bc6\u7801\u6821\u9a8c")
    @PostMapping(value={"/passwordCheck"})
    public Result<?> passwordCheck(@RequestBody PasswordCheckParamVO checkParamVO) {
        return Result.ok((Object)this.passwordSecurityService.checkPassword(this.getElsAccount(), checkParamVO.getPassword()));
    }

    @Operation(summary="\u5bc6\u7801\u6821\u9a8c", description="\u5bc6\u7801\u6821\u9a8c")
    @PostMapping(value={"/noToken/passwordCheck"})
    public Result<?> passwordCheck2(@RequestBody PasswordCheckParamVO checkParamVO) {
        return Result.ok((Object)this.passwordSecurityService.checkPassword(ConfigUtil.getPurchaseAccount(), checkParamVO.getPassword()));
    }

    @Operation(summary="\u68c0\u67e5\u5f53\u524d\u8d26\u53f7\u5bc6\u7801\u662f\u5426\u9700\u8981\u4fee\u6539", description="\u68c0\u67e5\u5f53\u524d\u8d26\u53f7\u5bc6\u7801\u662f\u5426\u9700\u8981\u4fee\u6539")
    @GetMapping(value={"/checkCurrentAccountPassword"})
    public Result<?> checkCurrentAccountPassword() {
        return Result.ok((Object)this.passwordSecurityService.checkUpdatePassword(this.getElsAccount(), SrmUtil.getLoginUser().getId()));
    }
}

