/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.platform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConfigUtil;
import com.els.modules.account.platform.vo.ChangePhoneParamVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.ChangePasswordParamVO;
import com.els.modules.system.vo.FrozenParamVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5e73\u53f0\u8d26\u53f7\u7ba1\u7406")
@RestController
@RequestMapping(value={"/base/platformAccount"})
public class PlatformAccountController
extends BaseController<ElsSubAccount, ElsSubAccountService> {
    @Resource
    private ElsSubAccountService subAccountService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"platformAccount:list"})
    public Result<?> queryPageList(ElsSubAccount accountInfoVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        this.checkPermission();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)accountInfoVO), (Map)req.getParameterMap());
        IPage pageList = this.subAccountService.page((IPage)page, (Wrapper)queryWrapper);
        List accountInfoList = pageList.getRecords();
        for (ElsSubAccount info : accountInfoList) {
            info.setPassword(null);
            info.setSalt(null);
            info.setSecret(null);
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e73\u53f0\u8d26\u53f7\u7ba1\u7406-\u6dfb\u52a0", operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"platformAccount:add"})
    public Result<?> addOther(@RequestBody JSONObject jsonObject) {
        this.checkPermission();
        return Result.ok((Object)((Object)this.subAccountService.addOther(jsonObject)));
    }

    private void checkPermission() {
        if (!this.getElsAccount().equals(ConfigUtil.getPurchaseAccount())) {
            throw new ELSBootException("\u5f53\u524dELS\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
    }

    @AutoLog(busModule="\u5e73\u53f0\u8d26\u53f7\u7ba1\u7406", value="\u66f4\u6539\u5bc6\u7801")
    @Operation(summary="\u66f4\u6539\u5bc6\u7801", description="\u66f4\u6539\u5bc6\u7801")
    @PostMapping(value={"/changePassword"})
    @RequiresPermissions(value={"platformAccount:changePassword"})
    public Result<?> changePassword(@RequestBody ChangePasswordParamVO paramVO) {
        this.checkPermission();
        this.subAccountService.changePassword(paramVO);
        return Result.ok();
    }

    @AutoLog(busModule="\u5e73\u53f0\u8d26\u53f7\u7ba1\u7406", value="\u66f4\u6539\u624b\u673a\u53f7")
    @Operation(summary="\u66f4\u6539\u624b\u673a\u53f7", description="\u66f4\u6539\u624b\u673a\u53f7")
    @PostMapping(value={"/changePhone"})
    @RequiresPermissions(value={"platformAccount:changePhone"})
    public Result<?> changePhone(@RequestBody ChangePhoneParamVO paramVO) {
        this.checkPermission();
        this.subAccountService.changePhone(paramVO);
        return Result.ok();
    }

    @AutoLog(busModule="\u8d26\u53f7\u7ba1\u7406", value="\u51bb\u7ed3/\u89e3\u51bb")
    @Operation(summary="\u51bb\u7ed3/\u89e3\u51bb", description="\u51bb\u7ed3/\u89e3\u51bb")
    @PostMapping(value={"/frozen"})
    @RequiresPermissions(value={"platformAccount:frozen"})
    public Result<?> frozen(@RequestBody FrozenParamVO paramVO) {
        this.checkPermission();
        this.subAccountService.frozen(paramVO);
        return this.commonSuccessResult();
    }
}

