/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.cache.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.cache.entity.ElsMybatisCacheInfo;
import com.els.modules.cache.mapper.ElsMybatisCacheInfoMapper;
import com.els.modules.cache.service.ElsMybatisCacheInfoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsMybatisCacheInfoServiceImpl
extends BaseServiceImpl<ElsMybatisCacheInfoMapper, ElsMybatisCacheInfo>
implements ElsMybatisCacheInfoService {
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void add(ElsMybatisCacheInfo elsMybatisCacheInfo) {
        this.checkValidity(elsMybatisCacheInfo);
        ((ElsMybatisCacheInfoMapper)this.baseMapper).insert((Object)elsMybatisCacheInfo);
    }

    @Override
    public void edit(ElsMybatisCacheInfo elsMybatisCacheInfo) {
        this.checkValidity(elsMybatisCacheInfo);
        int count = ((ElsMybatisCacheInfoMapper)this.baseMapper).updateById((Object)elsMybatisCacheInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsMybatisCacheInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsMybatisCacheInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void clearCache(String id) {
        ElsMybatisCacheInfo elsMybatisCacheInfo = (ElsMybatisCacheInfo)((Object)((ElsMybatisCacheInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (elsMybatisCacheInfo != null) {
            if (elsMybatisCacheInfo.getMapperClassName().equals("ALL")) {
                this.redisUtil.deleteBykeyword("Mapper");
            } else {
                this.redisUtil.deleteBykeyword(elsMybatisCacheInfo.getMapperClassName());
            }
        }
    }

    private void checkValidity(ElsMybatisCacheInfo elsMybatisCacheInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"mapper_class_name", (Object)elsMybatisCacheInfo.getMapperClassName())).lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        ElsMybatisCacheInfo cacheInfo = (ElsMybatisCacheInfo)((Object)((ElsMybatisCacheInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (cacheInfo != null && !cacheInfo.getId().equals(elsMybatisCacheInfo.getId())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IMKrER_924fac9d", (String)"\u5df2\u5b58\u5728\u8be5\u914d\u7f6e\uff01"));
        }
    }
}

