/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.custom.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.custom.entity.PurchaseCustomFormHead;
import com.els.modules.custom.entity.SaleCustomFormHead;
import com.els.modules.custom.mapper.PurchaseCustomFormHeadMapper;
import com.els.modules.custom.service.PurchaseCustomFormExtendService;
import com.els.modules.custom.service.PurchaseCustomFormHeadService;
import com.els.modules.custom.service.PurchaseCustomFormItemExtendService;
import com.els.modules.custom.service.SaleCustomFormHeadService;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseCustomFormHeadServiceImpl
extends BaseServiceImpl<PurchaseCustomFormHeadMapper, PurchaseCustomFormHead>
implements PurchaseCustomFormHeadService {
    @Resource
    private PurchaseCustomFormExtendService purchaseCustomFormExtendService;
    @Resource
    private PurchaseCustomFormItemExtendService purchaseCustomFormItemExtendService;
    @Resource
    private PurchaseAttachmentService purchaseAttachmentService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public PurchaseCustomFormHead saveMain(JSONObject headObj) {
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), PurchaseCustomFormHead.class));
        formHead.setId(IdWorker.getIdStr());
        this.save((Object)formHead);
        headObj.put("id", (Object)formHead.getId());
        headObj.put("elsAccount", (Object)TenantContext.getTenant());
        this.purchaseCustomFormExtendService.save(headObj);
        this.purchaseCustomFormItemExtendService.save(headObj);
        return formHead;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(JSONObject headObj) {
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), PurchaseCustomFormHead.class));
        this.updateById((Object)formHead);
        this.purchaseCustomFormExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        this.purchaseCustomFormItemExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        this.purchaseCustomFormExtendService.save(headObj);
        this.purchaseCustomFormItemExtendService.save(headObj);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateHead(JSONObject headObj) {
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), PurchaseCustomFormHead.class));
        this.updateById((Object)formHead);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id, String businessType) {
        this.purchaseCustomFormExtendService.deleteByMainId(id, businessType);
        this.purchaseCustomFormItemExtendService.deleteByMainId(id, businessType);
        ((PurchaseCustomFormHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void send(JSONObject headObj) {
        String id;
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), PurchaseCustomFormHead.class));
        if (StrUtil.isBlank((CharSequence)formHead.getRelationId())) {
            formHead.setRelationId(IdWorker.getIdStr());
        }
        if (StrUtil.isBlank((CharSequence)(id = formHead.getId()))) {
            formHead.setId(IdWorker.getIdStr());
            this.save((Object)formHead);
            headObj.put("id", (Object)formHead.getId());
            headObj.put("elsAccount", (Object)TenantContext.getTenant());
        } else {
            this.updateById((Object)formHead);
            this.purchaseCustomFormExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
            this.purchaseCustomFormItemExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        }
        this.purchaseCustomFormExtendService.save(headObj);
        this.purchaseCustomFormItemExtendService.save(headObj);
        ((SaleCustomFormHeadService)SpringContextUtils.getBean(SaleCustomFormHeadService.class)).recevie(headObj, formHead);
        AttachmentSendVO sendVO = new AttachmentSendVO();
        sendVO.setElsAccount(TenantContext.getTenant());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(formHead.getRelationId(), formHead.getToElsAccount());
        sendVO.setToSend(toSend);
        sendVO.setHeadId(formHead.getId());
        this.purchaseAttachmentService.sendFile(sendVO);
    }

    @Override
    public void recevie(JSONObject headObj, SaleCustomFormHead saleFormHead) {
        if (StrUtil.isBlank((CharSequence)saleFormHead.getToElsAccount())) {
            throw new ELSBootException("\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PurchaseCustomFormHead purchaseformHead = new PurchaseCustomFormHead();
        BeanUtils.copyProperties((Object)((Object)saleFormHead), (Object)((Object)purchaseformHead));
        purchaseformHead.setId(saleFormHead.getRelationId());
        purchaseformHead.setRelationId(saleFormHead.getId());
        purchaseformHead.setElsAccount(saleFormHead.getToElsAccount());
        purchaseformHead.setToElsAccount(saleFormHead.getElsAccount());
        purchaseformHead.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        PurchaseCustomFormHead dbHead = (PurchaseCustomFormHead)((Object)((PurchaseCustomFormHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseformHead.getId())));
        if (dbHead == null) {
            this.save((Object)purchaseformHead);
        } else {
            this.updateById((Object)purchaseformHead);
            this.purchaseCustomFormExtendService.deleteByMainId(purchaseformHead.getId(), purchaseformHead.getBusinessType());
            this.purchaseCustomFormItemExtendService.deleteByMainId(purchaseformHead.getId(), purchaseformHead.getBusinessType());
        }
        headObj.put("id", (Object)purchaseformHead.getId());
        headObj.put("elsAccount", (Object)purchaseformHead.getElsAccount());
        this.purchaseCustomFormExtendService.save(headObj);
        this.purchaseCustomFormItemExtendService.save(headObj);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void sendHead(JSONObject headObj) {
        String id;
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), PurchaseCustomFormHead.class));
        if (StrUtil.isBlank((CharSequence)formHead.getRelationId())) {
            formHead.setRelationId(IdWorker.getIdStr());
        }
        if (StrUtil.isBlank((CharSequence)(id = formHead.getId()))) {
            formHead.setId(IdWorker.getIdStr());
            this.save((Object)formHead);
        } else {
            this.updateById((Object)formHead);
        }
        ((SaleCustomFormHeadService)SpringContextUtils.getBean(SaleCustomFormHeadService.class)).recevieHead(formHead);
    }
}

