/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.ElsAttachmentPart;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9500\u552e\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/saleAttachment"})
public class SaleAttachmentController
extends BaseController<SaleAttachment, SaleAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(SaleAttachmentController.class);
    @Autowired
    private SaleAttachmentService attachmentSaleService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"attachment#saleAttachment:list"})
    public Result<?> queryPageList(SaleAttachment attachmentSale, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)attachmentSale), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.attachmentSaleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20\u6587\u4ef6", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        List<String> txFields = Arrays.asList("effectiveDate", "expiryDate", "caType", "saveType");
        JSONObject param = new JSONObject();
        Map parameterMap = request.getParameterMap();
        for (String key : parameterMap.keySet()) {
            if (txFields.contains(key)) continue;
            String[] values = (String[])parameterMap.get(key);
            param.put(key, (Object)values[0]);
        }
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)param), (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        Assert.hasText((String)param.getString("businessType"), (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        Assert.hasText((String)param.getString("headId"), (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        String saveType = request.getParameter("saveType");
        String caType = request.getParameter("caType");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, saveType, caType);
                SaleAttachment attachment = (SaleAttachment)((Object)JSONObject.toJavaObject((JSON)param, SaleAttachment.class));
                if (StringUtils.isNotBlank((CharSequence)fileInfo.getId())) {
                    attachment.setId(fileInfo.getId());
                }
                if (CharSequenceUtil.isEmpty((CharSequence)attachment.getFileType())) {
                    attachment.setFileType("5");
                }
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(TenantContext.getTenant());
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                SysUtil.checkFileType((String)uploadFile.getOriginalFilename());
                boolean result = this.attachmentSaleService.saveAttachment(attachment);
                if (!result) continue;
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", operateType=2)
    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", notes="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadLog"})
    public Result<?> uploadLog(@Valid @RequestBody List<SaleAttachment> attachmentList) {
        for (SaleAttachment attachment : attachmentList) {
            attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
            attachment.setUploadElsAccount(TenantContext.getTenant());
            attachment.setSendStatus("0");
            attachment.setReceiveStatus("0");
            attachment.setUploadTime(new Date());
            attachment.setSaveType(CharSequenceUtil.emptyToDefault((CharSequence)attachment.getSaveType(), (String)this.fileStoreSignServiceImpl.activeType()));
            attachment.setSourceType("1");
            if (!CharSequenceUtil.isEmpty((CharSequence)attachment.getFileType())) continue;
            attachment.setFileType("5");
        }
        this.attachmentSaleService.saveBatch(attachmentList);
        return Result.ok(attachmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"attachment#saleAttachment:downloadZip"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u4e0b\u8f7d", operateType=1)
    @PostMapping(value={"/downloadZip"})
    public void downloadZip(@RequestBody List<String> ids, HttpServletResponse response) throws IOException {
        List attachmentList = this.attachmentSaleService.listByIds(ids);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"downloadZip.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bufferedInputStream = null;
        int bufSize = 51200;
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (SaleAttachment attachment : attachmentList) {
            try {
                int length;
                InputStream inputStream = this.fileStoreSignServiceImpl.downloadFileWithInputStream(attachment.getFilePath(), attachment.getSaveType());
                bufferedInputStream = new BufferedInputStream(inputStream, bufSize);
                byte[] data = new byte[bufSize];
                Integer count = (Integer)nameIndex.get(attachment.getFileName());
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                nameIndex.put(attachment.getFileName(), count);
                String fileName = attachment.getFileName();
                if (count > 1) {
                    int index = fileName.lastIndexOf(".");
                    String name = fileName.substring(0, index);
                    String sux = fileName.substring(index);
                    fileName = name + "(" + count.toString() + ")" + sux;
                }
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOutputStream.putNextEntry(zipEntry);
                while ((length = bufferedInputStream.read(data)) != -1) {
                    zipOutputStream.write(data, 0, length);
                    response.flushBuffer();
                }
            }
            catch (Exception e) {
                log.error("{}\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)attachment.getFileName(), (Object)e.getMessage());
            }
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
    }

    private void headBuilder(HttpServletResponse response, HttpServletRequest request, String filename) throws Exception {
        filename = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(filename, "UTF-8") : new String(filename.getBytes("UTF-8"), "ISO8859-1");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
    }

    @RequiresPermissions(value={"attachment#saleAttachment:download"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        try {
            SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
            if (attachment == null) {
                PurchaseAttachmentService purchaseAttachmentService = (PurchaseAttachmentService)SpringContextUtils.getBean(PurchaseAttachmentService.class);
                PurchaseAttachment purchaseAttachment = (PurchaseAttachment)((Object)purchaseAttachmentService.getById((Serializable)((Object)id)));
                if (purchaseAttachment == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                }
                this.headBuilder(response, request, purchaseAttachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), purchaseAttachment.getFilePath(), purchaseAttachment.getSaveType());
            } else {
                this.headBuilder(response, request, attachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/noToken/download"})
    public void downloadNoToken(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        try {
            SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
            if (attachment == null) {
                PurchaseAttachmentService purchaseAttachmentService = (PurchaseAttachmentService)SpringContextUtils.getBean(PurchaseAttachmentService.class);
                PurchaseAttachment purchaseAttachment = (PurchaseAttachment)((Object)purchaseAttachmentService.getById((Serializable)((Object)id)));
                if (purchaseAttachment == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                }
                this.headBuilder(response, request, purchaseAttachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), purchaseAttachment.getFilePath(), purchaseAttachment.getSaveType());
            } else {
                this.headBuilder(response, request, attachment.getFileName());
                this.fileStoreSignServiceImpl.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @RequiresPermissions(value={"attachment#saleAttachment:delete"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == attachment) {
            return this.commonSuccessResult(4);
        }
        String elsAccount = this.getTenantId();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_uvCXVQIWxqQG_7e96bcc2", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n_alert_IhdjQIWxqQG_29a7fa21", (String)"\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.fileStoreSignServiceImpl.delete(attachment.getFilePath(), attachment.getSaveType());
        this.attachmentSaleService.delAttachmentSale(id);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:deleteBatch"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List saleAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        String elsAccount = this.getTenantId();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(saleAttachmentList = this.attachmentSaleService.listByIds(idList)))) {
            for (SaleAttachment saleAttachment : saleAttachmentList) {
                Assert.isTrue((boolean)"0".equals(saleAttachment.getSendStatus()), (String)I18nUtil.translate((String)"i18n__QIWWWWWWIhdWxqQG_99c3bdd", (String)"\u6587\u4ef6[${0}]\u5df2\u53d1\u9001\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{saleAttachment.getFileName()}));
                Assert.isTrue((boolean)elsAccount.equals(saleAttachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6[${0}]\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{saleAttachment.getFileName()}));
                filePaths.add(saleAttachment.getFilePath());
            }
        }
        this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, null);
        this.attachmentSaleService.delBatchAttachmentSale(idList);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:queryById"})
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleAttachment attachmentSale = (SaleAttachment)((Object)this.attachmentSaleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)attachmentSale));
    }

    @RequiresPermissions(value={"attachment#saleAttachment:send"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @ApiOperation(value="\u9644\u4ef6\u53d1\u9001", notes="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.attachmentSaleService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:delete"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u7279\u6b8a\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u7279\u6b8a\u5220\u9664", notes="\u901a\u8fc7id\u7279\u6b8a\u5220\u9664")
    @GetMapping(value={"/specialDelete"})
    public Result<?> specialDelete(@RequestParam(name="id") String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        if (null == attachment) {
            return this.commonSuccessResult(4);
        }
        String elsAccount = this.getTenantId();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_uvCXVQIWxqQG_7e96bcc2", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.attachmentSaleService.delAttachmentSale(id);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:deleteBatch"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u7279\u6b8a\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u7279\u6b8a\u6279\u91cf\u5220\u9664", notes="\u7279\u6b8a\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/specialDeleteBatch"})
    public Result<?> specialDeleteBatch(@RequestParam(name="ids") String ids) {
        List saleAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        String elsAccount = this.getTenantId();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(saleAttachmentList = this.attachmentSaleService.listByIds(idList)))) {
            for (SaleAttachment saleAttachment : saleAttachmentList) {
                Assert.isTrue((boolean)elsAccount.equals(saleAttachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6[${0}]\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664", (String[])new String[]{saleAttachment.getFileName()}));
                filePaths.add(saleAttachment.getFilePath());
            }
        }
        this.attachmentSaleService.delBatchAttachmentSale(idList);
        return this.commonSuccessResult(4);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u83b7\u53d6\u4e0a\u4f20\u9644\u4ef6\u7684uploadId", operateType=1)
    @GetMapping(value={"/getPartUploadId"})
    public Result<?> getPartUploadId(@RequestParam(name="fileName") String fileName) {
        SysUtil.checkFileType((String)fileName);
        String partUploadId = this.fileStoreSignServiceImpl.getPartUploadId(fileName);
        return Result.ok((String)partUploadId);
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20\u5206\u7247", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u5206\u7247", notes="\u4e0a\u4f20\u5206\u7247")
    @RequestMapping(value={"/uploadPart"}, method={RequestMethod.POST})
    public Result<?> uploadPart(@RequestParam(value="uploadId") String uploadId, @RequestParam(value="fileName") String fileName, @RequestParam(value="partIndex") Integer partIndex, HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                ElsAttachmentPart part = new ElsAttachmentPart();
                part.setPartIndex(partIndex);
                part.setUploadId(uploadId);
                part.setFileName(fileName);
                part.setPartTotal(request.getParameter("partTotal"));
                this.fileStoreSignServiceImpl.uploadPart(part, (MultipartFile)entity.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5206\u7247\u5931\u8d25", (Throwable)e);
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    @RequiresPermissions(value={"attachment#saleAttachment:upload"})
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20\u5206\u7247\u5b8c\u6210", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u5206\u7247\u5b8c\u6210", notes="\u4e0a\u4f20\u5206\u7247\u5b8c\u6210")
    @RequestMapping(value={"/completePartUpload"}, method={RequestMethod.POST})
    public Result<?> completePartUpload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String uploadId = request.getParameter("uploadId");
        Assert.hasText((String)uploadId, (String)"uploadId\u4e0d\u80fd\u4e3a\u7a7a");
        String materialNumber = request.getParameter("materialNumber");
        String materialName = request.getParameter("materialName");
        String factory = request.getParameter("factory");
        String sourceNumber = request.getParameter("sourceNumber");
        String actionRoutePath = request.getParameter("actionRoutePath");
        String saveType = request.getParameter("saveType");
        String uploadType = request.getParameter("uploadType");
        if (StrUtil.isBlank((CharSequence)businessType)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        }
        List<ElsAttachmentPart> partList = this.fileStoreSignServiceImpl.completePartUpload(uploadId);
        long fileSize = 0L;
        for (ElsAttachmentPart part : partList) {
            String partSize = part.getPartSize();
            fileSize += Long.parseLong(partSize);
        }
        ElsAttachmentPart part = partList.get(0);
        SaleAttachment attachment = new SaleAttachment();
        attachment.setBusinessType(businessType);
        attachment.setHeadId(headId);
        attachment.setItemNumber(itemNumber);
        attachment.setFileType(CharSequenceUtil.emptyToDefault((CharSequence)fileType, (String)"5"));
        attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
        attachment.setUploadElsAccount(TenantContext.getTenant());
        attachment.setFileName(part.getFileName());
        attachment.setFileSize(String.valueOf(fileSize));
        attachment.setFilePath(part.getFilePath());
        attachment.setSaveType(saveType);
        attachment.setSendStatus("0");
        attachment.setReceiveStatus("0");
        attachment.setUploadTime(new Date());
        attachment.setFactory(factory);
        attachment.setUploadType(uploadType);
        attachment.setActionRoutePath(actionRoutePath);
        attachment.setSourceNumber(sourceNumber);
        attachment.setMaterialNumber(materialNumber);
        attachment.setMaterialName(materialName);
        attachment.setMaterialNumber(materialNumber);
        boolean result = this.attachmentSaleService.saveAttachment(attachment);
        if (result) {
            attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
            return Result.ok((Object)((Object)attachment));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }
}

