/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.rpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.contract.service.SaleContractHeadService;
import java.text.MessageFormat;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseContract_audit")
public class purchaseContractAuditSingleServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(purchaseContractAuditSingleServiceImpl.class);
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Autowired
    private SaleContractHeadService saleContractHeadService;
    @Resource
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "purchase_contract_audit";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject invoke(JSONObject arg0) {
        String requestId = arg0.getString("requestId");
        String auditStatus = arg0.getString("auditStatus");
        String rejectReason = arg0.getString("rejectReason");
        String nodeId = arg0.getString("nodeId");
        String workflowId = arg0.getString("workflowId ");
        log.error("purchaseContract_audit ~ changeNumber:{}, auditStatus: {},rejectReason:{},nodeId:{},workflowId:{}", new Object[]{requestId, auditStatus, rejectReason, nodeId, workflowId});
        JSONObject res = new JSONObject();
        if (StringUtils.isEmpty((String)requestId) || StringUtils.isEmpty((String)auditStatus)) {
            res.put("result", (Object)false);
            res.put("message", (Object)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a!");
            return res;
        }
        if (!AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            res.put("result", (Object)false);
            res.put("message", (Object)"\u5ba1\u6838\u72b6\u6001\u4e0d\u5bf9!");
            return res;
        }
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, requestId, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"OA\u56de\u5199\u5ba1\u6279\u7ed3\u679c\u81f3SRM\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c"));
        }
        try {
            res = this.dealAuditStatus(arg0);
        }
        catch (Exception e) {
            res.put("message", (Object)e.getMessage());
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, requestId);
        }
        log.error(MessageFormat.format("OA\u56de\u5199\u5ba1\u6279\u7ed3\u679c\u81f3SRM \u51fa\u53c2\uff1a\u3010{0}\u3011", res.toJSONString()));
        return res;
    }

    private JSONObject dealAuditStatus(JSONObject arg0) {
        String auditStatus = arg0.getString("auditStatus");
        LambdaUpdateWrapper update = new LambdaUpdateWrapper();
        update.set(PurchaseContractHead::getAuditStatus, (Object)auditStatus);
        update.set(PurchaseContractHead::getFlowId, (Object)arg0.getString("workflowId "));
        update.eq(PurchaseContractHead::getContractNumber, (Object)arg0.getString("requestId"));
        Boolean flag = this.purchaseContractHeadService.update((Wrapper)update);
        LambdaUpdateWrapper update2 = new LambdaUpdateWrapper();
        update2.set(SaleContractHead::getAuditStatus, (Object)arg0.getString("auditStatus"));
        update2.set(SaleContractHead::getFlowId, (Object)arg0.getString("workflowId "));
        update2.eq(SaleContractHead::getContractNumber, (Object)arg0.getString("requestId"));
        Boolean flag2 = this.saleContractHeadService.update((Wrapper)update2);
        JSONObject res = new JSONObject();
        res.put("result", (Object)(flag != false && flag2 != false ? 1 : 0));
        res.put("message", (Object)"\u64cd\u4f5c\u6210\u529f");
        return res;
    }
}

