/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.PurchaseContractContentItemHis;
import com.els.modules.contract.entity.PurchaseContractHeadHis;
import com.els.modules.contract.entity.PurchaseContractItemHis;
import com.els.modules.contract.service.PurchaseContractContentItemHisService;
import com.els.modules.contract.service.PurchaseContractHeadHisService;
import com.els.modules.contract.service.PurchaseContractItemHisService;
import com.els.modules.contract.utils.NumberUtil;
import com.els.modules.contract.utils.PdfUtil;
import com.els.modules.contract.vo.PurchaseContractHeadHisVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contract/purchaseContractHeadHis"})
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u5934"})
public class PurchaseContractHeadHisController
extends BaseController<PurchaseContractHeadHis, PurchaseContractHeadHisService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractHeadHisController.class);
    @Autowired
    private PurchaseContractHeadHisService purchaseContractHeadHisService;
    @Autowired
    private PurchaseContractItemHisService purchaseContractItemHisService;
    @Autowired
    private PurchaseContractContentItemHisService purchaseContractContentItemHisService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseContractHeadHis purchaseContractHeadHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHeadHis), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractHeadHisService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/listSimple"})
    @PermissionDataView(businessType="contract")
    public Result<?> listSimple(PurchaseContractHeadHis purchaseContractHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        purchaseContractHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(PurchaseContractHeadHis::getContractType, (Object)"3");
        IPage pageList = this.purchaseContractHeadHisService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseContractHeadHisVO purchaseContractHeadHisPage) {
        PurchaseContractHeadHis purchaseContractHeadHis = new PurchaseContractHeadHis();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadHisPage), (Object)((Object)purchaseContractHeadHis));
        this.purchaseContractHeadHisService.saveMain(purchaseContractHeadHis, purchaseContractHeadHisPage.getPurchaseContractItemHisList(), purchaseContractHeadHisPage.getPurchaseContractContentItemHisList(), purchaseContractHeadHisPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseContractHeadHis));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseContractHeadHisVO purchaseContractHeadHisPage) {
        PurchaseContractHeadHis purchaseContractHeadHis = new PurchaseContractHeadHis();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadHisPage), (Object)((Object)purchaseContractHeadHis));
        this.purchaseContractHeadHisService.updateMain(purchaseContractHeadHis, purchaseContractHeadHisPage.getPurchaseContractItemHisList(), purchaseContractHeadHisPage.getPurchaseContractContentItemHisList(), purchaseContractHeadHisPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractHeadHisService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseContractHeadHisService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractHeadHis purchaseContractHeadHis = (PurchaseContractHeadHis)((Object)this.purchaseContractHeadHisService.getById((Serializable)((Object)id)));
        PurchaseContractHeadHisVO purchaseContractHeadHisVO = new PurchaseContractHeadHisVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractHeadHis), (Object)((Object)purchaseContractHeadHisVO));
        List<PurchaseContractItemHis> purchaseContractItemHisList = this.purchaseContractItemHisService.selectByMainId(id);
        purchaseContractHeadHisVO.setPurchaseContractItemHisList(purchaseContractItemHisList);
        List<PurchaseContractContentItemHis> purchaseContractContentItemHisList = this.purchaseContractContentItemHisService.selectByMainId(id);
        purchaseContractHeadHisVO.setPurchaseContractContentItemHisList(purchaseContractContentItemHisList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseContractHeadHisVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseContractHeadHisVO));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e", notes="\u91c7\u8d2d\u5408\u540c\u5934-\u901a\u8fc7id\u83b7\u53d6\u9884\u89c8\u6570\u636e")
    @GetMapping(value={"/getPreviewData"})
    public Result<?> getPreviewData(@RequestParam(name="id", required=true) String id) {
        return Result.ok((Object)this.getHtmlById(id));
    }

    public StringBuilder getHtmlById(String id) {
        Result<?> result = this.queryById(id);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        PurchaseContractHeadHisVO purchaseContractHeadVO = (PurchaseContractHeadHisVO)((Object)JSON.parseObject((String)result.getResult().toString(), PurchaseContractHeadHisVO.class));
        JSONObject jsonObject = (JSONObject)result.getResult();
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || next.getValue().toString().split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemHisList"));
        List<PurchaseContractContentItemHis> contractBuyContentItemList = purchaseContractHeadVO.getPurchaseContractContentItemHisList();
        int index = 0;
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItemHis item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block22: {
            String html = this.getHtmlById(id).toString();
            PurchaseContractHeadHis contractBuyHead = (PurchaseContractHeadHis)((Object)this.purchaseContractHeadHisService.getById((Serializable)((Object)id)));
            String path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), String.valueOf(contractBuyHead.getContractNumber()) + "_" + contractBuyHead.getContractVersion(), null);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                try {
                    File file = new File(path);
                    if (file.exists()) {
                        int len;
                        response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                        inputStream = new BufferedInputStream(new FileInputStream(file));
                        outputStream = response.getOutputStream();
                        byte[] buf = new byte[1024];
                        while ((len = inputStream.read(buf)) > 0) {
                            outputStream.write(buf, 0, len);
                        }
                        outputStream.flush();
                    }
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            log.error("printStackTrace:", (Throwable)e2);
                        }
                    }
                    if (outputStream == null) break block22;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e3) {
                        log.error("printStackTrace:", (Throwable)e3);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
            }
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u884c")
    @GetMapping(value={"/queryPurchaseContractItemHisByMainId"})
    public Result<?> queryPurchaseContractItemHisListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractItemHis> purchaseContractItemHisList = this.purchaseContractItemHisService.selectByMainId(id);
        return Result.ok(purchaseContractItemHisList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6761\u6b3e\u5386\u53f2\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u5408\u540c\u5386\u53f2\u5934id\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u6761\u6b3e\u5386\u53f2\u884c")
    @GetMapping(value={"/queryPurchaseContractContentItemHisByMainId"})
    public Result<?> queryPurchaseContractContentItemHisListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseContractContentItemHis> purchaseContractContentItemHisList = this.purchaseContractContentItemHisService.selectByMainId(id);
        return Result.ok(purchaseContractContentItemHisList);
    }
}

