/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.contract.entity.PurchaseContractParam;
import com.els.modules.contract.service.PurchaseContractParamService;
import com.els.rpc.service.InvokeAccountRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u53c2\u6570"})
@RestController
@RequestMapping(value={"/contract/purchaseContractParam"})
public class PurchaseContractParamController
extends BaseController<PurchaseContractParam, PurchaseContractParamService> {
    @Autowired
    private PurchaseContractParamService purchaseContractParamService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseContractParam purchaseContractParam, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractParam), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractParamService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageListSys"})
    public Result<?> queryPageListSys(PurchaseContractParam purchaseContractParam, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractParam), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
        IPage pageList = this.purchaseContractParamService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseContractParam purchaseContractParam) {
        this.purchaseContractParamService.savePurchaseContractParam(purchaseContractParam);
        return Result.ok((Object)((Object)purchaseContractParam));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseContractParam purchaseContractParam) {
        this.purchaseContractParamService.updatePurchaseContractParam(purchaseContractParam);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @AutoLog(busModule="\u5408\u540c\u53c2\u6570", value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseContractParamService.delPurchaseContractParam(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseContractParamService.delBatchPurchaseContractParam(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseContractParam purchaseContractParam = (PurchaseContractParam)((Object)this.purchaseContractParamService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseContractParam));
    }

    @ApiOperation(value="\u590d\u5236\u5408\u540c\u53c2\u6570\u7ed9\u6307\u5b9aelsAccount", notes="\u590d\u5236\u5408\u540c\u53c2\u6570\u7ed9\u6307\u5b9aelsAccount")
    @GetMapping(value={"/toElsAccount/{elsAccount}"})
    public Result<?> copyToElsAccount(@PathVariable(value="elsAccount") String elsAccount) {
        ElsSubAccountDTO account = this.invokeAccountRpcService.getAccount(elsAccount, "1001");
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_elsAccountNotFound", (String)"\u5f53\u524dELSAccount[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{elsAccount}));
        }
        List copyList = this.purchaseContractParamService.list();
        this.purchaseContractParamService.copyToElsAccount(copyList, elsAccount);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

