/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.entity.ContractItemCustom1;
import com.els.modules.contract.entity.PurchaseContractContentItem;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractItem;
import com.els.modules.contract.entity.SaleContractContentItem;
import com.els.modules.contract.entity.SaleContractHead;
import com.els.modules.contract.entity.SaleContractItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.enumerate.ContractPromiseSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.contract.mapper.PurchaseContractContentItemMapper;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractItemMapper;
import com.els.modules.contract.mapper.SaleContractContentItemMapper;
import com.els.modules.contract.mapper.SaleContractHeadMapper;
import com.els.modules.contract.mapper.SaleContractItemMapper;
import com.els.modules.contract.service.SaleContractHeadService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.vo.SaleContractHeadVO;
import com.els.modules.contract.vo.SaleContractPromiseVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SaleContractHeadServiceImpl
extends BaseServiceImpl<SaleContractHeadMapper, SaleContractHead>
implements SaleContractHeadService {
    @Resource
    private SaleContractHeadMapper saleContractHeadMapper;
    @Resource
    private SaleContractItemMapper saleContractItemMapper;
    @Resource
    private SaleContractContentItemMapper saleContractContentItemMapper;
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Resource
    private PurchaseContractItemMapper purchaseContractItemMapper;
    @Resource
    private PurchaseContractContentItemMapper purchaseContractContentItemMapper;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleContractHeadMapper.insert((Object)saleContractHead);
        this.insertData(saleContractHead, saleContractItemList, saleContractContentItemList, saleAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleContractHeadMapper.updateById((Object)saleContractHead);
        this.saleContractItemMapper.deleteByMainId(saleContractHead.getId());
        this.saleContractContentItemMapper.deleteByMainId(saleContractHead.getId());
        this.insertData(saleContractHead, saleContractItemList, saleContractContentItemList, saleAttachmentList);
    }

    private void insertData(SaleContractHead saleContractHead, List<SaleContractItem> saleContractItemList, List<SaleContractContentItem> saleContractContentItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        for (SaleContractItem saleContractItem : saleContractItemList) {
            saleContractItem.setHeadId(saleContractHead.getId());
            SysUtil.setSysParam((BaseEntity)saleContractItem, (BaseEntity)saleContractHead);
        }
        if (!saleContractItemList.isEmpty()) {
            this.saleContractItemMapper.insertBatchSomeColumn(saleContractItemList);
        }
        for (SaleContractContentItem saleContractContentItem : saleContractContentItemList) {
            saleContractContentItem.setHeadId(saleContractHead.getId());
            SysUtil.setSysParam((BaseEntity)saleContractContentItem, (BaseEntity)saleContractHead);
        }
        if (!saleContractContentItemList.isEmpty()) {
            this.saleContractContentItemMapper.insertBatchSomeColumn(saleContractContentItemList);
        }
        if (!CollectionUtils.isEmpty(saleAttachmentList)) {
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(null);
                saleAttachmentDTO.setHeadId(saleContractHead.getId());
                saleAttachmentDTO.setUploadElsAccount(saleContractHead.getElsAccount());
                saleAttachmentDTO.setBusinessType("contract");
                saleAttachmentDTO.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleContractHead);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleContractItemMapper.deleteByMainId(id);
        this.saleContractContentItemMapper.deleteByMainId(id);
        this.saleContractHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmedMain(String id) {
        this.publishPurchase(id, ContractStatusEnum.CONFIRMED.getValue(), null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void refundMain(String id, String refundRemark) {
        this.publishPurchase(id, ContractStatusEnum.REFUND.getValue(), refundRemark);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishPurchase(String id, String status, String refundRemark) {
        String urlParam;
        SaleContractHead saleHead = (SaleContractHead)((Object)this.saleContractHeadMapper.selectById((Serializable)((Object)id)));
        if (ContractStatusEnum.CANCEL.getValue().equals(saleHead.getContractStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_contractDisabled", (String)"\u5408\u540c\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\uff01"));
        }
        List<SaleContractContentItem> saleContractContentItems = this.saleContractContentItemMapper.selectByMainId(id);
        List<SaleContractItem> saleContractItems = this.saleContractItemMapper.selectByMainId(id);
        List saleAttachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        SaleContractHead updateBuyHead = new SaleContractHead();
        if (status.equals(ContractStatusEnum.CONFIRMED.getValue())) {
            updateBuyHead.setContractStatus(ContractStatusEnum.CONFIRMED.getValue());
            updateBuyHead.setId(id);
            urlParam = "id=" + saleHead.getRelationId();
            super.sendMsg(saleHead.getElsAccount(), saleHead.getToElsAccount(), (Object)saleHead, urlParam, "contract", "confirm");
        } else if (status.equals(ContractStatusEnum.REFUND.getValue())) {
            updateBuyHead.setContractStatus(ContractStatusEnum.REFUND.getValue());
            updateBuyHead.setId(id);
            if (StrUtil.isNotBlank((CharSequence)refundRemark)) {
                updateBuyHead.setRefundRemark(refundRemark);
            }
            urlParam = "id=" + saleHead.getRelationId();
            super.sendMsg(saleHead.getElsAccount(), saleHead.getToElsAccount(), (Object)saleHead, urlParam, "contract", "refund");
        }
        this.saleContractHeadMapper.updateById((Object)updateBuyHead);
        PurchaseContractHead purchaseHead = new PurchaseContractHead();
        BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)purchaseHead));
        purchaseHead.setContractStatus(updateBuyHead.getContractStatus());
        purchaseHead.setRelationId(id);
        if (StrUtil.isBlank((CharSequence)saleHead.getRelationId())) {
            purchaseHead.setId(null);
            purchaseHead.setElsAccount(saleHead.getToElsAccount());
            this.purchaseContractHeadMapper.insert((Object)purchaseHead);
        } else {
            purchaseHead.setId(saleHead.getRelationId());
            purchaseHead.setElsAccount(saleHead.getBusAccount());
            purchaseHead.setToElsAccount(saleHead.getElsAccount());
            this.purchaseContractHeadMapper.updateById((Object)purchaseHead);
            this.purchaseContractContentItemMapper.deleteByMainId(saleHead.getRelationId());
            this.purchaseContractItemMapper.deleteByMainId(saleHead.getRelationId());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleHead.getRelationId());
        }
        ArrayList<PurchaseContractContentItem> purchaseContractContentItemList = new ArrayList<PurchaseContractContentItem>();
        for (SaleContractContentItem saleContractContentItem : saleContractContentItems) {
            PurchaseContractContentItem purchaseContractContentItem = new PurchaseContractContentItem();
            BeanUtils.copyProperties((Object)((Object)saleContractContentItem), (Object)((Object)purchaseContractContentItem));
            purchaseContractContentItem.setId(null);
            purchaseContractContentItem.setElsAccount(purchaseHead.getElsAccount());
            purchaseContractContentItem.setHeadId(purchaseHead.getId());
            purchaseContractContentItemList.add(purchaseContractContentItem);
        }
        if (!purchaseContractContentItemList.isEmpty()) {
            this.purchaseContractContentItemMapper.insertBatchSomeColumn(purchaseContractContentItemList);
        }
        ArrayList<PurchaseContractItem> purchaseContractItemList = new ArrayList<PurchaseContractItem>();
        for (SaleContractItem item : saleContractItems) {
            PurchaseContractItem purchaseContractItem = new PurchaseContractItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseContractItem));
            purchaseContractItem.setId(null);
            purchaseContractItem.setElsAccount(purchaseHead.getElsAccount());
            purchaseContractItem.setHeadId(purchaseHead.getId());
            purchaseContractItemList.add(purchaseContractItem);
        }
        if (!purchaseContractItemList.isEmpty()) {
            this.purchaseContractItemMapper.insertBatchSomeColumn(purchaseContractItemList);
        }
        ArrayList<PurchaseAttachmentDTO> arrayList = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO item : saleAttachments) {
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)item, (Object)purchaseAttachment);
            item.setSendStatus("1");
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(purchaseHead.getElsAccount());
            purchaseAttachment.setHeadId(purchaseHead.getId());
            arrayList.add(purchaseAttachment);
        }
        if (!arrayList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(arrayList);
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleContractItemMapper.deleteByMainId(serializable.toString());
            this.saleContractContentItemMapper.deleteByMainId(serializable.toString());
            this.saleContractHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<SaleContractPromiseVO> createPromiseByItems(SaleContractHeadVO headVO) {
        List<ContractItemCustom1> contractItemCustom1List = headVO.getContractItemCustom1List();
        List<SaleContractItem> saleContractItemList = headVO.getPurchaseContractItemList();
        String id = "";
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)contractItemCustom1List.get(0).getHeadId())));
            id = purchaseContractHead.getRelationId();
        }
        if (!CollectionUtils.isEmpty(saleContractItemList)) {
            id = saleContractItemList.get(0).getHeadId();
        }
        SaleContractHead byId = (SaleContractHead)((Object)this.getById((Serializable)((Object)id)));
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        templateHeadDTO.setTemplateAccount(headVO.getTemplateAccount());
        templateHeadDTO.setTemplateName(headVO.getTemplateName());
        templateHeadDTO.setTemplateNumber(headVO.getTemplateNumber());
        templateHeadDTO.setTemplateVersion(Integer.valueOf(headVO.getTemplateVersion()));
        List<SaleContractPromiseVO> saleContractPromiseVOS = this.contractPromiseParam(templateHeadDTO, byId, contractItemCustom1List, saleContractItemList);
        saleContractPromiseVOS.forEach(item -> this.saleContractPromiseService.saveMain((SaleContractPromise)((Object)item), item.getPurchasePromiseItemList()));
        return saleContractPromiseVOS;
    }

    private List<SaleContractPromiseVO> contractPromiseParam(TemplateHeadDTO templateHeadDTO, SaleContractHead saleContractHead, List<ContractItemCustom1> contractItemCustom1List, List<SaleContractItem> saleContractItemList) {
        ArrayList<SaleContractPromiseVO> contractPromiseArrayList = new ArrayList<SaleContractPromiseVO>();
        if (!CollectionUtils.isEmpty(saleContractItemList)) {
            SaleContractPromiseVO saleContractPromiseVO = new SaleContractPromiseVO();
            saleContractPromiseVO.setSourceType(ContractPromiseSourceTypeEnum.ITEM.getValue());
            saleContractPromiseVO.setTemplateAccount(templateHeadDTO.getTemplateAccount());
            saleContractPromiseVO.setTemplateName(templateHeadDTO.getTemplateName());
            saleContractPromiseVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            saleContractPromiseVO.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
            saleContractPromiseVO.setContractAmount(saleContractHead.getTotalTaxAmount());
            saleContractPromiseVO.setContractNumber(saleContractHead.getContractNumber());
            saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)saleContractHead.getTargetQuantity())) {
                saleContractPromiseVO.setContractAmount(new BigDecimal(saleContractHead.getTargetQuantity()));
            } else {
                saleContractPromiseVO.setContractAmount(saleContractHead.getTotalNetAmount());
            }
            saleContractPromiseVO.setContractName(saleContractHead.getContractName());
            saleContractPromiseVO.setContractDesc(saleContractHead.getContractDesc());
            saleContractPromiseVO.setToElsAccount(saleContractHead.getToElsAccount());
            if (StringUtils.isEmpty((Object)saleContractHead.getTargetType())) {
                saleContractPromiseVO.setTargetType(ContractTargetTypeEnum.MONEY.getValue());
            } else {
                saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
            }
            saleContractPromiseVO.setBusAccount(saleContractHead.getBusAccount());
            saleContractPromiseVO.setCreateAccount(TenantContext.getTenant());
            saleContractPromiseVO.setHeadId(saleContractHead.getId());
            ArrayList<SalePromiseItem> salePromiseItemList = new ArrayList<SalePromiseItem>();
            for (SaleContractItem saleContractItem : saleContractItemList) {
                SalePromiseItem salePromiseItem = new SalePromiseItem();
                BeanUtils.copyProperties((Object)((Object)saleContractItem), (Object)((Object)salePromiseItem));
                salePromiseItem.setSourceItemId(saleContractItem.getId());
                salePromiseItem.setHeadId(null);
                salePromiseItem.setId(null);
                salePromiseItem.setCreateBy(null);
                salePromiseItem.setCreateTime(null);
                salePromiseItem.setUpdateBy(null);
                salePromiseItem.setUpdateTime(null);
                salePromiseItem.setToElsAccount(saleContractHead.getToElsAccount());
                salePromiseItem.setContractNumber(saleContractHead.getContractNumber());
                salePromiseItem.setContractName(saleContractHead.getContractName());
                salePromiseItem.setContractDesc(saleContractHead.getContractDesc());
                salePromiseItem.setAmount(saleContractItem.getTaxAmount());
                salePromiseItemList.add(salePromiseItem);
            }
            saleContractPromiseVO.setPurchasePromiseItemList(salePromiseItemList);
            if (!CollectionUtils.isEmpty(salePromiseItemList)) {
                BigDecimal targetQuantityArry = BigDecimal.ZERO;
                targetQuantityArry = salePromiseItemList.parallelStream().filter(p -> p.getAmount() != null).map(SalePromiseItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                saleContractPromiseVO.setAmount(targetQuantityArry);
            }
            contractPromiseArrayList.add(saleContractPromiseVO);
        }
        if (!CollectionUtils.isEmpty(contractItemCustom1List)) {
            for (ContractItemCustom1 contractItemCustom1 : contractItemCustom1List) {
                SaleContractPromiseVO saleContractPromiseVO = new SaleContractPromiseVO();
                saleContractPromiseVO.setTemplateAccount(templateHeadDTO.getTemplateAccount());
                saleContractPromiseVO.setTemplateName(templateHeadDTO.getTemplateName());
                saleContractPromiseVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                saleContractPromiseVO.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
                saleContractPromiseVO.setSourceType(ContractPromiseSourceTypeEnum.MILESTONE.getValue());
                saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
                saleContractPromiseVO.setContractNumber(saleContractHead.getContractNumber());
                saleContractPromiseVO.setContractName(saleContractHead.getContractName());
                saleContractPromiseVO.setContractDesc(saleContractHead.getContractDesc());
                saleContractPromiseVO.setStage(contractItemCustom1.getStage());
                saleContractPromiseVO.setSourceItemId(contractItemCustom1.getId());
                saleContractPromiseVO.setHeadId(contractItemCustom1.getHeadId());
                saleContractPromiseVO.setBusAccount(saleContractHead.getBusAccount());
                saleContractPromiseVO.setCreateAccount(TenantContext.getTenant());
                saleContractPromiseVO.setToElsAccount(saleContractHead.getToElsAccount());
                saleContractPromiseVO.setAmount(contractItemCustom1.getAmount());
                saleContractPromiseVO.setTargetType(saleContractHead.getTargetType());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)saleContractHead.getTargetQuantity())) {
                    saleContractPromiseVO.setContractAmount(new BigDecimal(saleContractHead.getTargetQuantity()));
                } else {
                    saleContractPromiseVO.setContractAmount(BigDecimal.ZERO);
                }
                saleContractPromiseVO.setPerformanceRatio(contractItemCustom1.getPerformanceRatio());
                saleContractPromiseVO.setPerformanceMatters(contractItemCustom1.getPerformanceMatters());
                contractPromiseArrayList.add(saleContractPromiseVO);
            }
        }
        return contractPromiseArrayList;
    }
}

