/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.mapper.PurchaseContractPromiseMapper;
import com.els.modules.contract.mapper.PurchasePromiseItemMapper;
import com.els.modules.contract.rpc.service.ContractInvokeDeliveryWaterRpcService;
import com.els.modules.contract.rpc.service.ContractInvokeWorkFlowRpcService;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.PurchasePromiseItemService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.service.SalePromiseItemService;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseContractPromiseServiceImpl
extends BaseServiceImpl<PurchaseContractPromiseMapper, PurchaseContractPromise>
implements PurchaseContractPromiseService {
    @Resource
    private PurchaseContractPromiseMapper purchaseContractPromiseMapper;
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ContractInvokeWorkFlowRpcService contractInvokeWorkFlowRpcService;
    @Resource
    private PurchasePromiseItemMapper purchasePromiseItemMapper;
    @Autowired
    private PurchasePromiseItemService promiseItemService;
    @Autowired
    private SalePromiseItemService salePromiseItemService;
    @Autowired
    private ContractInvokeDeliveryWaterRpcService contractInvokeDeliveryWaterRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseContractPromise purchaseContractPromise, List<PurchasePromiseItem> purchasePromiseItemList) {
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getPromiseNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)purchaseContractPromise);
            purchaseContractPromise.setPromiseNumber(nextCode);
        }
        super.setHeadDefaultValue((BaseEntity)purchaseContractPromise);
        if (purchaseContractPromise.getAmount() != null && purchaseContractPromise.getContractAmount() != null && purchaseContractPromise.getContractAmount().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal divide = purchaseContractPromise.getAmount().divide(purchaseContractPromise.getContractAmount(), 4, 4);
            purchaseContractPromise.setPerformanceRatio(divide.multiply(new BigDecimal(100)).setScale(2) + "%");
        }
        this.purchaseContractPromiseMapper.insert((Object)purchaseContractPromise);
        this.insertData(purchaseContractPromise, purchasePromiseItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseContractPromise purchaseContractPromise, List<PurchasePromiseItem> purchasePromiseItemList) {
        String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
        if ("0".equals(purchaseContractPromise.getAudit())) {
            auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        if (purchaseContractPromise.getAmount() != null && purchaseContractPromise.getContractAmount() != null && purchaseContractPromise.getContractAmount().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal divide = purchaseContractPromise.getAmount().divide(purchaseContractPromise.getContractAmount(), 4, 4);
            purchaseContractPromise.setPerformanceRatio(divide.multiply(new BigDecimal(100)).setScale(2) + "%");
        }
        this.purchaseContractPromiseMapper.updateById((Object)purchaseContractPromise);
        this.purchasePromiseItemMapper.deleteByMainId(purchaseContractPromise.getId());
        this.insertData(purchaseContractPromise, purchasePromiseItemList);
    }

    private void insertData(PurchaseContractPromise purchaseContractPromise, List<PurchasePromiseItem> purchasePromiseItemList) {
        if (!CollectionUtils.isEmpty(purchasePromiseItemList)) {
            for (PurchasePromiseItem entity : purchasePromiseItemList) {
                entity.setHeadId(purchaseContractPromise.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseContractPromise);
                entity.setPromiseNumber(purchaseContractPromise.getPromiseNumber());
            }
            if (!purchasePromiseItemList.isEmpty()) {
                this.purchasePromiseItemMapper.insertBatchSomeColumn(purchasePromiseItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePromiseItemMapper.deleteByMainId(id);
        this.purchaseContractPromiseMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePromiseItemMapper.deleteByMainId(serializable.toString());
            this.purchaseContractPromiseMapper.deleteById(serializable);
        }
    }

    @Override
    public List<PurchaseContractPromise> selectByMainId(String mainId) {
        return this.purchaseContractPromiseMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void savePurchaseContractPromise(PurchaseContractPromise purchaseContractPromise) {
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getPromiseNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)purchaseContractPromise);
            purchaseContractPromise.setPromiseNumber(nextCode);
        }
        purchaseContractPromise.setBusAccount(TenantContext.getTenant());
        super.setHeadDefaultValue((BaseEntity)purchaseContractPromise);
        String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
        if ("0".equals(purchaseContractPromise.getAudit())) {
            auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        }
        purchaseContractPromise.setAuditStatus(auditStatus);
        ((PurchaseContractPromiseMapper)this.baseMapper).insert((Object)purchaseContractPromise);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updatePurchaseContractPromise(PurchaseContractPromise purchaseContractPromise) {
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getPromiseNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmContractPromise", (Object)purchaseContractPromise);
            purchaseContractPromise.setPromiseNumber(nextCode);
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
            if ("0".equals(purchaseContractPromise.getAudit())) {
                auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            }
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        ((PurchaseContractPromiseMapper)this.baseMapper).updateById((Object)purchaseContractPromise);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delPurchaseContractPromise(String id) {
        ((PurchaseContractPromiseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchPurchaseContractPromise(List<String> idList) {
        ((PurchaseContractPromiseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishEvent(PurchaseContractPromise purchaseContractPromise) {
        PurchaseContractPromise purchaseContractPromise1 = (PurchaseContractPromise)((Object)this.purchaseContractPromiseMapper.selectById((Serializable)((Object)purchaseContractPromise.getId())));
        List<PurchasePromiseItem> purchasePromiseItemList = this.purchasePromiseItemMapper.selectByMainId(purchaseContractPromise.getId());
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseContractPromise1.getHeadId()), (String)I18nUtil.translate((String)"i18n_alert_ViFne_f7530d7b", (String)"\u8bf7\u9009\u62e9\u5408\u540c"));
        PurchaseContractHead purchaseContractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadMapper.selectById((Serializable)((Object)purchaseContractPromise1.getHeadId())));
        SaleContractPromise saleContractPromise = new SaleContractPromise();
        BeanUtil.copyProperties((Object)((Object)purchaseContractPromise), (Object)((Object)saleContractPromise), (String[])new String[0]);
        if ("1".equals(purchaseContractPromise.getSupplierConfirm())) {
            saleContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONTRACT_PROMISE_CONFIRMING.getValue());
        } else {
            saleContractPromise.setPromiseStatus(ContractPromiseStatusEnum.CONFIRMED.getValue());
        }
        saleContractPromise.setHeadId(purchaseContractHead.getRelationId());
        saleContractPromise.setElsAccount(purchaseContractHead.getToElsAccount());
        saleContractPromise.setToElsAccount(purchaseContractHead.getElsAccount());
        saleContractPromise.setRelationId(purchaseContractPromise1.getId());
        ArrayList<SalePromiseItem> salePromiseItems = new ArrayList<SalePromiseItem>();
        if (!CollectionUtils.isEmpty(purchasePromiseItemList)) {
            for (PurchasePromiseItem purchasePromiseItem : purchasePromiseItemList) {
                SalePromiseItem salePromiseItem = new SalePromiseItem();
                BeanUtil.copyProperties((Object)((Object)purchasePromiseItem), (Object)((Object)salePromiseItem), (String[])new String[0]);
                salePromiseItem.setId(IdWorker.getIdStr());
                salePromiseItem.setRelationId(purchasePromiseItem.getId());
                salePromiseItem.setHeadId(null);
                purchasePromiseItem.setRelationId(salePromiseItem.getId());
                salePromiseItem.setElsAccount(purchaseContractPromise.getToElsAccount());
                salePromiseItem.setToElsAccount(purchaseContractPromise.getElsAccount());
                salePromiseItems.add(salePromiseItem);
            }
        }
        if (ContractPromiseStatusEnum.REFUND.getValue().equals(purchaseContractPromise1.getPromiseStatus())) {
            saleContractPromise.setId(purchaseContractPromise1.getRelationId());
            this.saleContractPromiseService.updateById((Object)saleContractPromise);
        } else {
            saleContractPromise.setId(IdWorker.getIdStr());
            this.saleContractPromiseService.save((Object)saleContractPromise);
            salePromiseItems.forEach(item -> item.setHeadId(saleContractPromise.getId()));
            this.salePromiseItemService.saveBatch(salePromiseItems);
        }
        if (StringUtils.isBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            String auditStatus = AuditStatusEnum.AUDIT_NEW.getValue();
            if ("0".equals(purchaseContractPromise.getAudit())) {
                auditStatus = AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
            }
            purchaseContractPromise.setAuditStatus(auditStatus);
        }
        this.promiseItemService.updateBatchById(purchasePromiseItemList);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseContractPromise.getId())).set(PurchaseContractPromise::getPromiseStatus, (Object)saleContractPromise.getPromiseStatus())).set(PurchaseContractPromise::getRelationId, (Object)saleContractPromise.getId())).set(PurchaseContractPromise::getAuditStatus, (Object)purchaseContractPromise.getAuditStatus())).update((Object)new PurchaseContractPromise());
        String urlParam = "id=" + saleContractPromise.getId();
        super.sendMsg(purchaseContractPromise1.getElsAccount(), purchaseContractPromise1.getToElsAccount(), (Object)purchaseContractPromise1, urlParam, "contractPromise", "publish");
    }

    @Override
    public void refundMain(String id, String refundRemark) {
        PurchaseContractPromise byId = (PurchaseContractPromise)((Object)this.getById((Serializable)((Object)id)));
        PurchaseContractPromise saleContractPromise1 = (PurchaseContractPromise)((Object)this.purchaseContractPromiseMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.REFUND.getValue())).set(PurchaseContractPromise::getRefundRemark, (Object)refundRemark)).update((Object)new PurchaseContractPromise());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleContractPromiseService.lambdaUpdate().eq(BaseEntity::getId, (Object)saleContractPromise1.getRelationId())).set(SaleContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.REFUND.getValue())).set(SaleContractPromise::getRefundRemark, (Object)refundRemark)).update((Object)new SaleContractPromise());
        String urlParam = "id=" + byId.getRelationId();
        super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), (Object)byId, urlParam, "contractPromise", "refundPurchase");
    }

    @Override
    public void confirmedSupplier(PurchaseContractPromise purchaseContractPromise) {
        boolean b;
        String audit = purchaseContractPromise.getAudit();
        boolean bl = b = !AuditStatusEnum.AUDIT_DOING.getValue().equals(purchaseContractPromise.getAuditStatus()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseContractPromise.getAuditStatus());
        if ("1".equals(audit) && b) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseContractPromise.getId())).set(PurchaseContractPromise::getAudit, (Object)audit)).set(PurchaseContractPromise::getFlowId, null)).update((Object)new PurchaseContractPromise());
            this.submitAudit(purchaseContractPromise);
        } else {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseContractPromise.getId())).set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CONFIRMED.getValue())).update((Object)new PurchaseContractPromise());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleContractPromiseService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseContractPromise.getRelationId())).set(SaleContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CONFIRMED.getValue())).update((Object)new SaleContractPromise());
            String urlParam = "id=" + purchaseContractPromise.getRelationId();
            super.sendMsg(purchaseContractPromise.getElsAccount(), purchaseContractPromise.getToElsAccount(), (Object)purchaseContractPromise, urlParam, "contractPromise", "confirmPurchase");
        }
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseContractPromise.getAuditStatus())) {
            PurchaseDeliveryWaterDTO purchaseDeliveryWaterVO = new PurchaseDeliveryWaterDTO();
            BeanUtil.copyProperties((Object)((Object)purchaseContractPromise), (Object)purchaseDeliveryWaterVO, (String[])new String[0]);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWaterVO)) {
                purchaseDeliveryWaterVO.setDocumentNumber(purchaseContractPromise.getPromiseNumber());
                purchaseDeliveryWaterVO.setTotalAmount(purchaseContractPromise.getAmount());
                purchaseDeliveryWaterVO.setDocumentStatus("\u5df2\u786e\u8ba4");
                this.contractInvokeDeliveryWaterRpcService.insert(purchaseDeliveryWaterVO);
            }
        }
    }

    private void submitAudit(PurchaseContractPromise purchaseContractPromise) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(purchaseContractPromise.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaseContractPromise.getFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(purchaseContractPromise.getFlowId())));
        }
        auditInputParamVO.setBusinessType("contractPromise");
        auditInputParamVO.setAuditSubject("\u5c65\u7ea6\u5355\u53f7:" + purchaseContractPromise.getPromiseNumber());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)purchaseContractPromise)));
        this.contractInvokeWorkFlowRpcService.submit(auditInputParamVO);
    }
}

