/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.PurchaseV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<PurchaseEsignV3OrgPsnMapper, PurchaseEsignV3OrgPsn>
implements PurchaseEsignV3OrgPsnService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private PurchaseEsignV3PersonalService personalService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3OrgPsn orgPsn;
        PurchaseEsignV3Personal personal = (PurchaseEsignV3Personal)((Object)this.personalService.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getPsnId())));
        Assert.notNull((Object)((Object)personal), (String)I18nUtil.translate((String)"i18n_field_rjRxKmLLiSLiLeR_709c4b5e", (String)"\u8be5\u5458\u5de5\u4e0d\u5728\u4e2a\u4eba\u8ba4\u8bc1\u4e2d"));
        OrgPsnAdminRp rp = this.sendEsignAdd(purchaseEsignV3OrgPsn, personal.getPsnName());
        if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
            if ("\u7528\u6237\u5df2\u7ecf\u662f\u5f53\u524d\u4f01\u4e1a\u6210\u5458".equals(rp.getUnaddedMembers().get(0).getFailedReason())) {
                this.handleEsignRemove(purchaseEsignV3OrgPsn.getOrgCode(), purchaseEsignV3OrgPsn.getPsnCode());
                rp = this.sendEsignAdd(purchaseEsignV3OrgPsn, personal.getPsnName());
                if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                    throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
                }
            } else {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)((Object)(orgPsn = (PurchaseEsignV3OrgPsn)((Object)((PurchaseEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3OrgPsn::getPsnId, (Object)purchaseEsignV3OrgPsn.getPsnId())).eq(PurchaseEsignV3OrgPsn::getOrgCode, (Object)purchaseEsignV3OrgPsn.getOrgCode())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0"))))))) {
            orgPsn.setRole(purchaseEsignV3OrgPsn.getRole());
            ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
        } else {
            ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).insert((Object)purchaseEsignV3OrgPsn);
        }
    }

    public OrgPsnAdminRp sendEsignAdd(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn, String psnName) {
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(purchaseEsignV3OrgPsn.getPsnCode());
        members.setMemberName(psnName);
        members.setRole(purchaseEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(purchaseEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        return rp;
    }

    @Override
    public void edit(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        int count = ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)purchaseEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void delete(String id) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<PurchaseV3OrgPsnVo> pageVo(Page<PurchaseV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    @Override
    @SrmTransaction
    public void removeStaff(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3OrgPsn pev = (PurchaseEsignV3OrgPsn)((Object)this.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getId())));
        this.handleEsignRemove(pev.getOrgCode(), pev.getPsnCode());
        this.removeById((Serializable)((Object)purchaseEsignV3OrgPsn.getId()));
    }

    public void handleEsignRemove(String orgCode, String psnCode) {
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(orgCode);
        orgPsnRemoveRq.getBase().setMemberPsnIds(psnCode);
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
        if (!rp.getDeletedMembers().contains(psnCode)) {
            if (CollUtil.isNotEmpty(rp.getUnaddedMembers())) {
                throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_EPsyVIHVKHRvj_d3e483a9", (String)"E\u7b7e\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
    }
}

