/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.contract.dto.SaleContractPromiseDTO;
import com.els.modules.contract.entity.SalePromiseItem;
import com.els.modules.contract.mapper.SalePromiseItemMapper;
import com.els.modules.contract.service.SalePromiseItemService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePromiseItemServiceImpl
extends BaseServiceImpl<SalePromiseItemMapper, SalePromiseItem>
implements SalePromiseItemService {
    @Resource
    private SalePromiseItemMapper salePromiseItemMapper;

    @Override
    public List<SalePromiseItem> selectByMainId(String mainId) {
        return this.salePromiseItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<SaleContractPromiseDTO> listSaleContractPromiseDTO(SaleContractPromiseDTO dto) {
        return this.salePromiseItemMapper.listSaleContractPromiseDTO(dto);
    }

    @Override
    public List<SaleContractPromiseDTO> listSaleContractPromiseItemDTO(SaleContractPromiseDTO dto) {
        return this.salePromiseItemMapper.listSaleContractPromiseItemDTO(dto);
    }

    @Override
    public List<SaleContractPromiseDTO> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtils.isEmpty(voucherNumbers)) {
            return new ArrayList<SaleContractPromiseDTO>();
        }
        HashSet<String> businessNumbers = new HashSet<String>();
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        for (String voucherNumber : voucherNumbers) {
            String[] businessNumber = voucherNumber.split("-");
            businessNumbers.add(businessNumber[0]);
            map.put((CallSite)((Object)(businessNumber[0] + "-" + businessNumber[1])), voucherNumber);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SalePromiseItem::getPromiseNumber, businessNumbers);
        List salePromiseItems = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)salePromiseItems)) {
            return new ArrayList<SaleContractPromiseDTO>();
        }
        ArrayList<SaleContractPromiseDTO> list = new ArrayList<SaleContractPromiseDTO>();
        for (SalePromiseItem salePromiseItem : salePromiseItems) {
            String hasExist = (String)map.get(salePromiseItem.getPromiseNumber() + "-" + salePromiseItem.getItemNumber());
            if (StrUtil.isBlank((CharSequence)hasExist)) continue;
            SaleContractPromiseDTO dto = new SaleContractPromiseDTO();
            BeanUtils.copyProperties((Object)((Object)salePromiseItem), (Object)dto);
            dto.setPromiseNumberItem(salePromiseItem.getItemNumber());
            list.add(dto);
        }
        return list;
    }
}

