/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnAdminRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgPsnRemoveRq;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3OrgPsnMapper;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.vo.PurchaseV3OrgPsnVo;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3OrgPsnServiceImpl
extends BaseServiceImpl<PurchaseEsignV3OrgPsnMapper, PurchaseEsignV3OrgPsn>
implements PurchaseEsignV3OrgPsnService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private PurchaseEsignV3PersonalService personalService;
    @Autowired
    @Lazy
    private PurchaseEsignV3OrgService orgService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3Personal personal = (PurchaseEsignV3Personal)((Object)this.personalService.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getPsnId())));
        Assert.notNull((Object)((Object)personal), (String)I18nUtil.translate((String)"i18n_field_rjRxKmLLiSLiLeR_709c4b5e", (String)"\u8be5\u5458\u5de5\u4e0d\u5728\u4e2a\u4eba\u8ba4\u8bc1\u4e2d"));
        OrgPsnAdminRp rp = this.sendEsignAdd(purchaseEsignV3OrgPsn, personal.getPsnName());
        if (!rp.getAddedMembers().contains(personal.getPsnId()) && CollUtil.isNotEmpty(rp.getUnaddedMembers()) && !"\u7528\u6237\u5df2\u7ecf\u662f\u5f53\u524d\u4f01\u4e1a\u6210\u5458".equals(rp.getUnaddedMembers().get(0).getFailedReason())) {
            throw new ELSBootException(rp.getUnaddedMembers().get(0).getFailedReason());
        }
        PurchaseEsignV3OrgPsn orgPsn = (PurchaseEsignV3OrgPsn)((Object)((PurchaseEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3OrgPsn::getPsnId, (Object)purchaseEsignV3OrgPsn.getPsnId())).eq(PurchaseEsignV3OrgPsn::getOrgCode, (Object)purchaseEsignV3OrgPsn.getOrgCode())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isNotEmpty((Object)((Object)orgPsn))) {
            orgPsn.setRole(purchaseEsignV3OrgPsn.getRole());
            ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
        } else {
            ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).insert((Object)purchaseEsignV3OrgPsn);
        }
    }

    public OrgPsnAdminRp sendEsignAdd(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn, String psnName) {
        OrgPsnAdminRq.Members members = new OrgPsnAdminRq.Members();
        members.setPsnId(purchaseEsignV3OrgPsn.getPsnCode());
        members.setMemberName(psnName);
        members.setRole(purchaseEsignV3OrgPsn.getRole());
        OrgPsnAdminRq orgPsnAdminRq = OrgPsnAdminRq.builder().base(new OrgPsnAdminRq.Base(purchaseEsignV3OrgPsn.getOrgCode())).body(new OrgPsnAdminRq.Body(Arrays.asList(members))).build();
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnAdminRq, "e3-org-psn-add", OrgPsnAdminRp.class);
        return rp;
    }

    @Override
    public void edit(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        int count = ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)purchaseEsignV3OrgPsn);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void delete(String id) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<PurchaseV3OrgPsnVo> pageVo(Page<PurchaseV3OrgPsnVo> page, String orgId, boolean notAdmin, String sealId) {
        return ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).pageVo(page, orgId, notAdmin, sealId);
    }

    @Override
    @SrmTransaction
    public void removeStaff(PurchaseEsignV3OrgPsn purchaseEsignV3OrgPsn) {
        PurchaseEsignV3OrgPsn pev = (PurchaseEsignV3OrgPsn)((Object)this.getById((Serializable)((Object)purchaseEsignV3OrgPsn.getId())));
        this.handleEsignRemove(pev.getOrgCode(), pev.getPsnCode());
        this.removeById((Serializable)((Object)purchaseEsignV3OrgPsn.getId()));
    }

    @Override
    public void synchronizeEmployees(String ids) {
        for (String id : ids.split(",")) {
            PurchaseEsignV3Org org = (PurchaseEsignV3Org)((Object)this.orgService.getById((Serializable)((Object)id)));
            OrgPsnQueryRq orgPsnQueryRq = new OrgPsnQueryRq();
            orgPsnQueryRq.setOrgId(org.getOrgId());
            orgPsnQueryRq.setPageSize("100");
            orgPsnQueryRq.setPageNum("1");
            OrgPsnQueryRp rp = this.ipassUtil.sendBaseRequest(orgPsnQueryRq, "e3-org-psn-query", OrgPsnQueryRp.class);
            if (!CollUtil.isNotEmpty(rp.getMembers())) continue;
            List admins = rp.getMembers().stream().filter(x -> Arrays.stream(x.getRole().split(",")).toList().contains("99")).collect(Collectors.toList());
            if (!admins.stream().map(x -> x.getPsnId()).collect(Collectors.toList()).contains(org.getPsnId())) {
                OrgPsnQueryRp.Member adminM = (OrgPsnQueryRp.Member)admins.get(0);
                org.setPsnId(adminM.getPsnId());
                org.setPsnName(adminM.getPsnName());
                org.setPsnAccount(Optional.ofNullable(adminM.getPsnAccount().getAccountMobile()).orElse(adminM.getPsnAccount().getAccountEmail()));
                this.orgService.updateById((Object)org);
            }
            for (OrgPsnQueryRp.Member member : rp.getMembers()) {
                PurchaseEsignV3OrgPsn orgPsn;
                String psnAccount = Optional.ofNullable(member.getPsnAccount().getAccountMobile()).orElse(member.getPsnAccount().getAccountEmail());
                PurchaseEsignV3Personal psn = this.personalService.getByPsnId(member.getPsnId());
                if (ObjectUtil.isEmpty((Object)((Object)psn))) {
                    psn = this.personalService.getByPsnAccount(psnAccount);
                }
                if (ObjectUtil.isEmpty((Object)((Object)psn))) {
                    psn = new PurchaseEsignV3Personal();
                    psn.setId(IdWorker.getIdStr());
                    psn.setElsAccount(org.getElsAccount());
                    psn.setPsnId(member.getPsnId());
                    psn.setPsnName(member.getPsnName());
                    psn.setPsnAccount(psnAccount);
                    psn.setSubAccount(psnAccount);
                    psn.setRealnameStatus("1");
                    this.personalService.save((Object)psn);
                    ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3OrgPsn::getOrgCode, (Object)org.getOrgId())).eq(PurchaseEsignV3OrgPsn::getPsnCode, (Object)member.getPsnId()));
                }
                if (ObjectUtil.isEmpty((Object)((Object)(orgPsn = (PurchaseEsignV3OrgPsn)((Object)((PurchaseEsignV3OrgPsnMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3OrgPsn::getPsnCode, (Object)member.getPsnId())).eq(PurchaseEsignV3OrgPsn::getOrgCode, (Object)org.getOrgId())).eq(BaseEntity::getElsAccount, (Object)org.getElsAccount())).eq(BaseEntity::getDeleted, (Object)"0"))))))) {
                    orgPsn = new PurchaseEsignV3OrgPsn();
                    orgPsn.setElsAccount(org.getElsAccount());
                    orgPsn.setOrgId(org.getId());
                    orgPsn.setOrgCode(org.getOrgId());
                    orgPsn.setPsnId(psn.getId());
                    orgPsn.setPsnCode(psn.getPsnId());
                }
                List<String> eRoles = Arrays.stream(member.getRole().split(",")).toList();
                ArrayList srmRoles = Lists.newArrayList();
                if (eRoles.contains("99")) {
                    srmRoles.add("1");
                }
                if (eRoles.contains("2")) {
                    srmRoles.add("2");
                }
                if (eRoles.contains("3")) {
                    srmRoles.add("3");
                }
                orgPsn.setRole(srmRoles.stream().collect(Collectors.joining(",")));
                if (StrUtil.isNotBlank((CharSequence)orgPsn.getId())) {
                    ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).updateById((Object)orgPsn);
                    continue;
                }
                ((PurchaseEsignV3OrgPsnMapper)this.baseMapper).insert((Object)orgPsn);
            }
        }
    }

    public void handleEsignRemove(String orgCode, String psnCode) {
        OrgPsnRemoveRq orgPsnRemoveRq = new OrgPsnRemoveRq();
        orgPsnRemoveRq.getBase().setOrgId(orgCode);
        orgPsnRemoveRq.getBase().setMemberPsnIds(psnCode);
        OrgPsnAdminRp rp = this.ipassUtil.sendRequest(orgPsnRemoveRq, "e3-org-psn-remove", OrgPsnAdminRp.class);
    }
}

