/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.xhtml.XHTMLConverter;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Word2HtmlUtil {
    private static final Logger log = LoggerFactory.getLogger(Word2HtmlUtil.class);

    static void docToHtml() throws Exception {
        String sourceFileName = "E:\\downloads\\CN202211111902_1.doc";
        String targetFileName = "E:\\downloads\\test.html";
        HWPFDocument wordDocument = new HWPFDocument((InputStream)new FileInputStream(sourceFileName));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(document);
        wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
        Document htmlDocument = wordToHtmlConverter.getDocument();
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult(new File(targetFileName));
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "utf-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        serializer.transform(domSource, streamResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void docxToHtml() throws Exception {
        String sourceFileName = "E:\\downloads\\\u519c\u526f\u4ea7\u54c1\u4e70\u5356\u5408\u540c\u3000GF\u20142000\u20140151.docx";
        String targetFileName = "E:\\downloads\\testdox.html";
        try (OutputStreamWriter outputStreamWriter = null;){
            XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(sourceFileName));
            XHTMLOptions options = XHTMLOptions.create();
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFileName), "utf-8");
            XHTMLConverter xhtmlConverter = (XHTMLConverter)XHTMLConverter.getInstance();
            xhtmlConverter.convert(document, (Writer)outputStreamWriter, (Options)options);
        }
    }

    public static void main(String[] args) throws Exception {
        Word2HtmlUtil.docxToHtml();
    }
}

